// Основные настройки проекта
#define ENABLE_OLED_DISPLAY    // Раскомментируйте для использования дисплея
#define ENABLE_BUTTON          // Раскомментируйте для использования кнопки
#define ENABLE_OTA             // OTA-обновление
#define ENABLE_WIFI            // Работа с WiFi
#define ENABLE_WEB_SERVER      // Веб-сервер
#define ENABLE_USART_SAMOVAR   // Управление по USART
#define PZEM_FILTR false       // Фильтр измерений мощности (если скачет)
#define ENABLE_MQTT            // Управление через MQTT
#define MODE 2                 // Режим работы 1-сортировка полуволн (SSR-xxDA или симистр), 2 - фазовый регулятор (SSR-xxDA), 0 - ШИМ (SSR-xxLA, SSR-xxDD).
#define STABILIZE_MODE 0       // 0 - стабилизация по измеряемой мощности, 1 - стабилизация по напряжению (аналог STAB AVR)
#define PMAX_TEN 2027          // Номинальная мощность ТЭНа по умолчанию
#define DEFAULT_TIME_REG 3     // Период регулирования по умолчанию (1-8 с)
#define DEFAULT_K_UPR 6        // Коэффициент воздействия по умолчанию (1-10)
#define DEFAULT_PWM_FREQ 1000  // Частота ШИМ по умолчанию (Гц)
#define DEFAULT_DELAY_LOW 491  // Нижний предел задержки (мкс) для фазового регулирования
#define DEFAULT_DELAY_HIGH 1150// Верхний предел задержки (мкс)
#define DELAY_TIME_DISPLACEMENT 199 // Смещение, компенсирующее неточность датчика пересечения с 0 (мкс)

// Настройки по умолчанию для WiFi
#define defaultSSID "" // Ссид и пароль по умолчанию, позволяет использовать два набора, первый можно сохранить в EEPROM 
#define defaultPass "" // через WEB интерфейс, это второй по ходу загрузки
#define WIFI_RECONNECT // Переподключаться при потере связи

// Настройки по умолчанию для MQTT
#define MQTT_SERVER "mqtt.broker.com"     // Адрес брокера или IP
#define MQTT_PORT 1883                    // Порт
#define MQTT_USER ""
#define MQTT_PASSWORD ""
#define MQTT_ATTEMPTS 1                   // Попытки подключения при инициализации
#define MQTT_RECONNECTION false           // Пытаться переподключиться при потере соединения
#define MQTT_TIME_PUBLICATION 10000       // Период публикаций, миллисекунд
#define MQTT_TOPIC_POWER "stab/power/set" // Топик для установки мощности
#define MQTT_TOPIC_BOOST "stab/boost/set" // Топик для включения/выключения режима разгона
#define MQTT_TOPIC_HEAT "stab/heat/set"   // Топик для включения/выключения нагрева
#define MQTT_TOPIC_STATUS "stab/status"   // Топик текущего статуса

// Константы для пинов
#define boostPin 16            // Реле разгона
#define heatPin 14             // Реле ТЭНов
#define zeroCrossPin 12        // Детектор нуля
#define triacPin 15            // Симистор или твердотельное реле
#define BUTTON_PIN 13          // Кнопка 
#define PZEM_RX_PIN 0          // RX, пины для software serial PZEM-004T
#define PZEM_TX_PIN 2          // TX 
//1 и 3 - TX0/RX0 для связи с Самоваром, 4 и 5 I2C. Свободные пины: A0 (0-1В)


//EEPROM
#define EEPROM_SIZE 512

// Адреса EEPROM для Wi-Fi
#define SSID_ADDR 0                 // 32 байта (SSID + нулевой символ)
#define PASS_ADDR 32                // 32 байта (пароль + нулевой символ)

// Адреса EEPROM для MQTT
#define MQTT_SERVER_ADDR 64         // 32 байта (адрес сервера + нулевой символ)
#define MQTT_PORT_ADDR 96           // 4 байт (порт MQTT, максимум 65535)
#define MQTT_USER_ADDR 100          // 32 байта (пользователь + нулевой символ)
#define MQTT_PASSWORD_ADDR 132      // 32 байта (пароль + нулевой символ)
#define MQTT_TOPIC_POWER_ADDR 164   // 64 байта (топик мощности + нулевой символ)
#define MQTT_TOPIC_BOOST_ADDR 228   // 64 байта (топик разгона + нулевой символ)
#define MQTT_TOPIC_HEAT_ADDR 292    // 64 байта (топик нагрева + нулевой символ)
#define MQTT_TOPIC_STATUS_ADDR 356  // 64 байта (топик статуса + нулевой символ)
#define MQTT_ATTEMPTS_ADDR 420      // 1 байт (количество попыток подключения)
#define MQTT_RECONNECTION_ADDR 421  // 1 байт (флаг переподключения)
#define MQTT_TIME_PUBLICATION_ADDR 422 // 4 байта (период публикаций, long)
#define MQTT_SAVED_FLAG_ADDR 426    // 1 байт (флаг сохранения MQTT)
#define MQTT_SAVED_FLAG_VALUE 1     // Значение флага, указывающее, что параметры MQTT были сохранены

// Адреса EEPROM для режима регулятора
#define MODE_SAVED_FLAG_ADDR 427    // 1 байт (флаг сохранения режима)
#define MODE_SAVED_FLAG_VALUE 1     // Значение флага, указывающее, что номер режима регулятора был сохранен
#define MODE_ADDR 428               // 1 байт (текущий режим)
#define TIME_REG_ADDR 429           // 4 байта (период регулирования) free
#define K_UPR_ADDR 433              // 4 байта (коэффициент воздействия)
#define PWM_FREQ_ADDR 437           // 4 байта (частота ШИМ)
#define DELAY_LOW_ADDR 441          // 4 байта (нижний предел задержки)
#define DELAY_HIGH_ADDR 445         // 4 байта (верхний предел задержки)
#define STABILIZE_MODE_ADDR 449     // 1 байт (режим стабилизации мощност / напряжение)
#define FILTER_ENABLED_ADDR 450     // 1 байт (фильтр мощности и напряжения)
#define PMAX_TEN_ADDR 451           // 4 байт (номинальная мощность ТЭНа)
#define DELAY_TIME_DISPLACEMENT_ADDR 455 // 4 байт (смещение времени открытия симистора)

#if defined(ENABLE_WEB_SERVER) || defined(ENABLE_MQTT) || defined(ENABLE_OTA)
#define ENABLE_WIFI 
#endif
#define ON true
#define OFF false