#include "Stab_config.h"

//#define DEBUG

// Инициализация OLED
void initOLED() {
  #ifdef ENABLE_OLED_DISPLAY
  LD.init();
  LD.setFont(Font_12x16);
  LD.clearDisplay();
  LD.printString_12x16("Start...", 24, 2);
  #endif
}
// Функция для обновления OLED 
void updateOLEDDisplay() {
  #ifdef ENABLE_OLED_DISPLAY
  char outstr[5];            // строка для вывода цифр на экран
  // Обновление значений на дисплее
  LD.setFont(Font_12x16);
  LD.printNumber(voltage, 1, 40, 4);
  dtostrf((long)power, 5, 0, outstr);
  LD.printString_12x16(outstr, 40, 0);
  //LD.printNumber((long)power, 0, 40, 0);
  dtostrf((long)powerSetpoint, 5, 0, outstr);
  LD.printString_12x16(outstr, 40, 2);
    switch (mode) {
    case (0): // ШИМ
      LD.printString_12x16("Ш", 112, 6);
      break;
    case (1): // Сортировка полуволн
      LD.printString_12x16("Б", 112, 6);
      break;
    case (2): // Фазовое
      LD.printString_12x16("Ф", 112, 6);
      break;
    }
    #ifdef ENABLE_WIFI  
    LD.setFont(Font_6x8);
    LD.printString_6x8(localIP.c_str(), 26, 7);
    LD.printNumber(RSSI, 26, 6);
    LD.setFont(Font_12x16);
    #endif
  #endif
}
// Функция для обновления OLED только целевой мощности 
void updateOLEDDisplay_SetPoverPoint() {
  #ifdef ENABLE_OLED_DISPLAY
  char outstr[5];            // строка для вывода цифр на экран
  // Обновление значений на дисплее
  dtostrf((long)powerSetpoint, 5, 0, outstr);
  LD.printString_12x16(outstr, 40, 2);
  #endif
}
// Функция для обновления OLED режима кнопки
void updateOLEDDisplay_ModeButton(bool modeUPP) {
  #ifdef ENABLE_OLED_DISPLAY
  if (modeUPP) LD.printString_12x16(">", 108, 2); else LD.printString_12x16("<", 108, 2); 
   #endif
}

// Функция для обновления OLED режима "разгон"
void updateOLEDDisplay_BoostMode() {
  #ifdef ENABLE_OLED_DISPLAY
  if (boostMode) LD.printString_12x16("B", 108, 0); else LD.printString_12x16(" ", 108, 0); 
  #endif
}
// Вывод на дисплей заголовков
void StaticOLEDDisplay() { 
  #ifdef ENABLE_OLED_DISPLAY
  LD.clearDisplay();
  LD.printString_12x16("U:", 0, 4);
  LD.printString_12x16("P:", 0, 0);
  LD.printString_12x16("P=>:", 0, 2);
    #ifdef ENABLE_WIFI  
  if (WiFi.status() == WL_CONNECTED) {
    LD.setFont(Font_6x8);
    LD.printString_6x8(F("IP: "), 1, 7);
    LD.printString_6x8(F("RSSI: "), 1, 6);
    LD.setFont(Font_12x16);
  } else {
    LD.setFont(Font_6x8);
    LD.printString_6x8("HS: 192.168.4.1", 6, 7);
    LD.setFont(Font_12x16);
  }
  #endif
  #endif
}