#include "Stab_config.h"

/// Шлем с задержкой отчеты Самовару 
void USART_SendReport(){
  #ifdef ENABLE_USART_SAMOVAR
  if (pendingResponse != ""){
  //if (pendingResponse != "" && millis() - lastRequestTime >= responseDelay) {
    Serial.print(pendingResponse);  // Отправляем ответ
    pendingResponse = "";  // Сбрасываем ожидающий ответ
  }
  #endif //ENABLE_USART_SAMOVAR
}
//Принимаем по UART запросы от Самовара
void USART_GetRequests() {
  #ifdef ENABLE_USART_SAMOVAR
  static String inoutString;
  static byte index = 0;

  while (Serial.available() > 0) {  // Используем аппаратный Serial
    char inChar = (char)Serial.read();  // Чтение очередного байта

    if (!index) { 
      if ((inChar == 'A') || (byte(inChar) == 0xD0)) { // Ждём первый символ посылки "A" или первый байт UTF-кириллицы
        inoutString = inChar;
        index = 1;
      }
    } else if (index++ < 13) { // Пока посылка не длиннее 13 символов, считаем её корректной
      if (inChar == 0x0D) { // Ждем последнего символа посылки <CR>
        index = 0;

        // Разбираем строку
        if (inoutString == "АТ+VO?") { // Запрос текущей мощности
          pendingResponse = "C";
          pendingResponse +=String((uint16_t)power);
          pendingResponse += '\r';  // Формируем ответ
          //lastRequestTime = millis();  // Запоминаем время получения запроса
        } else if (inoutString == "АТ+VS?") { // Запрос уставки текущей мощности
          pendingResponse = "T";
          pendingResponse +=String((uint16_t)powerSetpoint);
          pendingResponse += '\r';  // Формируем ответ
          //lastRequestTime = millis();  // Запоминаем время получения запроса
        } else if (inoutString == "AT+SS?" || inoutString == "АТ+SS?") { // Запрос режима

          if (boostMode) {
            pendingResponse = "M1\r"; // Режим разгона
          } else if (!heatEnabled) {
            pendingResponse = "M2\r"; // Режим стоп
          } else {
            pendingResponse = "M0\r"; // Рабочий режим
          }
          //lastRequestTime = millis();  // Запоминаем время получения запроса
        } else if (inoutString == "AT+ON=0" || inoutString == "АТ+ON=0") { // Запрос на выключение нагрева
          boost(OFF);
          heat(OFF);
          inoutString = "";
          PowerLevel = 0; powerSetpoint =0;
        } else if (inoutString == "AT+ON=1" || inoutString == "АТ+ON=1") { // Запрос на включение режима "Разгон"
          if (!boostMode) { 
            boost(ON); }
          inoutString = "";
        } else if (inoutString.substring(0, 8) == "АТ+VS=") { // Запрос на изменение уставки мощности
          uint16_t newPower = inoutString.substring(8).toInt();
            setPower(newPower);
          if (newPower == 0) {
            heat(OFF);
            boost(OFF);
            powerSetpoint = 0;
          }
          inoutString = "";
        }
      } else { // Еще не конец
        inoutString += inChar; // Добавляем символ в строку
      }
    } else { // Посылка слишком длинная, начинаем сначала
      index = 0;
    }
  }
  #endif //ENABLE_USART_SAMOVAR
}
