#include "Stab_config.h"
#include "web_pages.h"

void setupWebServer() {
#ifdef ENABLE_WEB_SERVER
    // Главная страница
    server.on("/", HTTP_GET, [](AsyncWebServerRequest *request) {
        request->send_P(200, "text/html", MAIN_PAGE);
    });

// Обработчик для проверки перезагрузки
server.on("/check_reboot", HTTP_GET, [](AsyncWebServerRequest *request) {
  static bool rebooted = true; // Флаг перезагрузки
  if (rebooted) {
    //Serial.println("Sending 'rebooted' response"); // Логируем отправку 'rebooted'
    request->send(200, "text/plain", "rebooted");
    rebooted = false; // Сбрасываем флаг после первой проверки
  } else {
    //Serial.println("Sending 'not_rebooted' response"); // Логируем отправку 'not_rebooted'
    request->send(200, "text/plain", "not_rebooted");
  }
});

// Обработчик для чекбокса режима регулятора
server.on("/set_regulator", HTTP_POST, [](AsyncWebServerRequest *request) {
  static int maxPTemp = maxPower;
  if (request->hasParam("regulator", true)) {
    String regulatorValue = request->getParam("regulator", true)->value();
    REG = (regulatorValue == "1");
    if (REG) {
      maxPower = maxPTemp;
      Serial.println("Регулятор введен");
    } else {
      maxPTemp = maxPower;
      maxPower = MaxPowerLevel;
      Serial.println("Регулятор выведен");
    }
  }
  request->send(200); // Отправляем пустой ответ
});

    // Получение данных в JSON
    server.on("/get_data", HTTP_GET, [](AsyncWebServerRequest *request) {
        String json = "{";
        json += "\"regulator\":" + String( REG ? "true" : "false") + ",";
        json += "\"voltage\":" + String( voltage, 1) + ",";
        json += "\"current\":" + String( current, 2) + ",";
        json += "\"power\":" + String( power) + ",";
        json += "\"powerSetpoint\":" + String( powerSetpoint) + ",";
        json += "\"maxPower\":" + String( maxPower) + ",";
        json += "\"PowerLevel\":" + String( PowerLevel) + ",";
        json += "\"MaxPowerLevel\":" + String( MaxPowerLevel) + ",";
        json += "\"energy\":" + String( energy, 3) + ",";
        json += "\"boostMode\":" + String( boostMode ? "true" : "false") + ",";
        json += "\"heatEnabled\":" + String( heatEnabled ? "true" : "false") + ",";
        json += "\"insufficientVoltage\":" + String( insufficientVoltage ? "true" : "false") + ",";
        json += "\"mode\":" + String( mode) + ",";
        json += "\"stabilizeMode\":" + String( stabilizeMode);
        json += "}";
        request->send(200, "application/json", json);
    });
    // Страница настроек
    server.on("/setup_wifi", HTTP_GET, [](AsyncWebServerRequest *request) {
        String html = FPSTR(SETTINGS_PAGE);
        
        // Замена плейсхолдеров
  html.replace("%.ssid", savedSSID);
  html.replace("%.pass", savedPass);
  html.replace("%.mqtt_server", mqtt_server);
  html.replace("%.mqtt_port", String(mqtt_port));
  html.replace("%.mqtt_user", mqtt_user);
  html.replace("%.mqtt_password", mqtt_password);
  html.replace("%.mqtt_topic_power", mqtt_topic_power);
  html.replace("%.mqtt_topic_boost", mqtt_topic_boost);
  html.replace("%.mqtt_topic_heat", mqtt_topic_heat);
  html.replace("%.mqtt_topic_status", mqtt_topic_status);
  html.replace("%.mqtt_attempts", String(mqtt_attempts));
  html.replace("%mqtt_reconnection_checked", mqtt_reconnection ? "checked" : "");
  html.replace("%.mqtt_time_publication", String(mqtt_time_publication));
  html.replace("%s1", hotspotMode ? "checked" : "");
  html.replace("%s2", !hotspotMode ? "checked" : "");
  html.replace("%s3", hotspotMode ? "none" : "block");
  html.replace("%mode%", String(mode));
  html.replace("%s0", mode == 0 ? "selected" : "");
  html.replace("%s1", mode == 1 ? "selected" : "");
  html.replace("%s2", mode == 2 ? "selected" : "");
  html.replace("%.time_reg", String(timeReg));
  html.replace("%.k_upr", String(K_upr));
  html.replace("%.pwm_freq", String(pwmFreq));
  html.replace("%.delay_low", String(delayLow));
  html.replace("%.delay_high", String(delayHigh));
  html.replace("%.displace", String(delayTimeDisplacement));
  html.replace("%stabilize_mode_0", stabilizeMode == 0 ? "selected" : "");
  html.replace("%stabilize_mode_1", stabilizeMode == 1 ? "selected" : "");
  html.replace("%filter_enabled_checked", filterEnabled ? "checked" : "");
  html.replace("%stabilize_mode%", String(stabilizeMode));
  html.replace("%filter_enabled%", filterEnabled ? "true" : "false");
  html.replace("%.PMAX", String(maxPower));
        
        request->send(200, "text/html", html);
    });
// Обработчик для сохранения режима регулирования
server.on("/save_mode", HTTP_POST, [](AsyncWebServerRequest *request) {
  if (request->hasParam("mode", true)) {
    mode = (byte) request->getParam("mode", true)->value().toInt();
    modeSwap(); // Меняем режим
    }
  if (request->hasParam("time_reg", true)) {
    timeReg = request->getParam("time_reg", true)->value().toInt();
    }
  if (request->hasParam("k_upr", true)) {
    K_upr = request->getParam("k_upr", true)->value().toInt();
    }
  if (request->hasParam("pwm_freq", true)) {
    pwmFreq = request->getParam("pwm_freq", true)->value().toInt();
    }  
  if (request->hasParam("delay_low", true)) {
    delayLow = request->getParam("delay_low", true)->value().toInt();
    }  
  if (request->hasParam("delay_high", true)) {
    delayHigh = request->getParam("delay_high", true)->value().toInt();
    }
  if (request->hasParam("displace", true)) {
    delayTimeDisplacement = request->getParam("displace", true)->value().toInt();
    }    
   String rememberValue = "0"; // По умолчанию значение "0", если чекбокс не установлен
  if (request->hasParam("remember", true)) {
    rememberValue = request->getParam("remember", true)->value();
  }
  if (request->hasParam("stabilize_mode", true)) {
  stabilizeMode = (byte) request->getParam("stabilize_mode", true)->value().toInt();
  //Serial.print("Стабилизация изменена: ");
  //Serial.println(stabilizeMode == 0 ? "Мощность" : "Напряжение");
  }
  filterEnabled = false;
  if (request->hasParam("filter_enabled", true)) {
  filterEnabled = (request->getParam("filter_enabled", true)->value() == "1");}
  Serial.print("Фильтр значений: ");
  Serial.println(filterEnabled ? "Включен" : "Выключен");
  if (request->hasParam("PMAX", true)) {
    maxPower = request->getParam("PMAX", true)->value().toInt();
  }  
  
      if (rememberValue == "1") { // Проверяем, установлен ли чекбокс "Запомнить"
        // Сохраняем режим в EEPROM
        EEPROM.begin(EEPROM_SIZE);
        EEPROM.write(MODE_ADDR, mode);
        EEPROM.put(TIME_REG_ADDR, timeReg);
        EEPROM.put(K_UPR_ADDR, K_upr);
        EEPROM.put(PWM_FREQ_ADDR, pwmFreq);
        EEPROM.put(DELAY_LOW_ADDR, delayLow);
        EEPROM.put(DELAY_HIGH_ADDR, delayHigh);
        EEPROM.put(DELAY_TIME_DISPLACEMENT_ADDR, delayTimeDisplacement);
        EEPROM.write(MODE_SAVED_FLAG_ADDR, MODE_SAVED_FLAG_VALUE);
        EEPROM.write(STABILIZE_MODE_ADDR, stabilizeMode);
        EEPROM.write(FILTER_ENABLED_ADDR, filterEnabled ? 1 : 0);
        EEPROM.put(PMAX_TEN_ADDR, maxPower);
        EEPROM.commit();
        EEPROM.end();
      }
  request->redirect("/"); // Перенаправляем на главную страницу
});
server.on("/set_mqtt_reconnection", HTTP_POST, [](AsyncWebServerRequest *request) {
  if (request->hasParam("reconnection", true)) {
    String rcnnVl = request->getParam("reconnection", true)->value();
    mqtt_reconnection = (rcnnVl == "1");
  }
  request->send(200); // Отправляем пустой ответ
});
server.on("/restart", HTTP_POST, [](AsyncWebServerRequest *request) {
  request->send(200, "text/plain", "Перезагрузка устройства...");
  ESP.reset(); // Перезагружаем устройство
});
 // Обработчик для установки мощности
server.on("/set_power", HTTP_POST, [](AsyncWebServerRequest *request) {
  if (request->hasParam("power", true)) {
    setPower((uint16_t)atof(request->getParam("power", true)->value().c_str()));
  }
  request->redirect("/"); // Перенаправляем на главную страницу
});
// Обработчик для включения/выключения режима "Разгон"
server.on("/set_boost", HTTP_POST, [](AsyncWebServerRequest *request) {
  if (request->hasParam("boost", true)) {
    boost(request->getParam("boost", true)->value() == "1");
  }
  request->send(200); // Отправляем пустой ответ
});
// Обработчик для включения/выключения нагрева
server.on("/set_heat", HTTP_POST, [](AsyncWebServerRequest *request) {
  if (request->hasParam("heat", true)) {
    heat(request->getParam("heat", true)->value() == "1");}
  request->send(200); // Отправляем пустой ответ
});
// Обработчик для сохранения настроек Wi-Fi
server.on("/save_wifi", HTTP_POST, [](AsyncWebServerRequest *request) {
  if (request->hasParam("mode", true)) {
    String mode = request->getParam("mode", true)->value();
    if (mode == "hotspot") {
      hotspotSetup();
    } else {
      String savedSSID = request->getParam("ssid", true)->value();
      String savedPass = request->getParam("pass", true)->value();
      WiFiSetup(savedSSID, savedPass);
    }
  }
  // Перенаправляем на главную страницу после сохранения
  request->redirect("/");
}); 
// Обработчик для сохранения настроек MQTT
server.on("/save_mqtt", HTTP_POST, [](AsyncWebServerRequest *request) {
  // Сохранение параметров MQTT
  EEPROM.begin(EEPROM_SIZE);
  if (request->hasParam("mqtt_server", true)) {
    mqtt_server = request->getParam("mqtt_server", true)->value();
    writeEEPROM(MQTT_SERVER_ADDR, mqtt_server, 31);    
  }
  if (request->hasParam("mqtt_port", true)) {
    mqtt_port = request->getParam("mqtt_port", true)->value().toInt();
    EEPROM.put(MQTT_PORT_ADDR, mqtt_port);
  }
  if (request->hasParam("mqtt_user", true)) {
    mqtt_user = request->getParam("mqtt_user", true)->value();
    writeEEPROM(MQTT_USER_ADDR, mqtt_user, 31);
  }
  if (request->hasParam("mqtt_password", true)) {
    mqtt_password = request->getParam("mqtt_password", true)->value();
    writeEEPROM(MQTT_PASSWORD_ADDR, mqtt_password, 31);
  }
  if (request->hasParam("mqtt_topic_power", true)) {
    mqtt_topic_power = request->getParam("mqtt_topic_power", true)->value();
    writeEEPROM(MQTT_TOPIC_POWER_ADDR, mqtt_topic_power, 63);
  }
  if (request->hasParam("mqtt_topic_boost", true)) {
    mqtt_topic_boost = request->getParam("mqtt_topic_boost", true)->value();
    writeEEPROM(MQTT_TOPIC_BOOST_ADDR, mqtt_topic_boost, 63);
  }
  if (request->hasParam("mqtt_topic_heat", true)) {
    mqtt_topic_heat = request->getParam("mqtt_topic_heat", true)->value();
    writeEEPROM(MQTT_TOPIC_HEAT_ADDR, mqtt_topic_heat, 63);
  }
  if (request->hasParam("mqtt_topic_status", true)) {
    mqtt_topic_status = request->getParam("mqtt_topic_status", true)->value();
    writeEEPROM(MQTT_TOPIC_STATUS_ADDR, mqtt_topic_status, 63);
  }
  if (request->hasParam("mqtt_attempts", true)) {
    mqtt_attempts = (byte) request->getParam("mqtt_attempts", true)->value().toInt() ;
    EEPROM.write(MQTT_ATTEMPTS_ADDR, mqtt_attempts);
  }
    EEPROM.write(MQTT_RECONNECTION_ADDR, mqtt_reconnection ? 1 : 0);

  if (request->hasParam("mqtt_time_publication", true)) {
    mqtt_time_publication = request->getParam("mqtt_time_publication", true)->value().toInt();
    EEPROM.put(MQTT_TIME_PUBLICATION_ADDR, mqtt_time_publication);
  }
  // Сохраняем флаг, указывающий, что параметры MQTT были сохранены
  EEPROM.write(MQTT_SAVED_FLAG_ADDR, MQTT_SAVED_FLAG_VALUE);
  EEPROM.commit();
  EEPROM.end();
  Serial.println("MQTT settings writed.");
  request->redirect("/");
 });
// Обработчик для сброса счетчика энергии
server.on("/reset_energy", HTTP_POST, [](AsyncWebServerRequest *request) {
  PzemEnClear = true; // Сбрасываем счетчик энергии
  request->redirect("/"); // Перенаправляем на главную страницу
 });

// Запуск сервера
server.begin();
 #endif // ENABLE_WEB_SERVER
}