// заголовки
  #include <asyncHTTPrequest.h>
  #include <ESPping.h>

  #include "Settings.h"
  #include "FS.h"

  extern float nbk_M;
  extern float nbk_Mo;
  extern float nbk_P;
  extern float nbk_Po;
  float get_speed_from_rate(float volume_per_hour, uint16_t s_per_l);
  void set_current_power(float Volt);
  void reset_wifi();
  uint16_t get_stepper_speed(void);
  bool set_stepper_target(uint16_t spd, uint8_t direction, uint32_t target);
  String get_program(uint8_t s);
  String get_beer_program();
  String get_dist_program();
  String get_nbk_program();
  float get_speed_from_rate(float rate, uint16_t s_per_l);
  float get_alcohol(float t);
  void set_mixer(bool On);
  void FS_init(void);
  void save_profile();
  void read_config();
  void WebServerInit(void);
  String get_DSAddressList(String Address);
  void set_pump_speed(float pumpspeed, bool continue_process);
  void start_self_test(void);
  void stop_self_test(void);
  String get_web_file(String fn, get_web_type type);
  void get_web_interface();
  String http_sync_request_get(String url);
  void set_water_temp(float temp);
  void set_power(bool On);
  void set_pump_pwm(float duty);
  void set_pump_speed_pid(float temp);
  void set_power_mode(String Mode);
  void set_capacity(uint8_t cap);
  void web_command(AsyncWebServerRequest *request);
  void handleSave(AsyncWebServerRequest *request);
  void get_data_log(AsyncWebServerRequest *request, String fn);
  void web_program(AsyncWebServerRequest *request);
  void calibrate_command(AsyncWebServerRequest *request);
  String get_DSAddressList(String Address);
  void set_pump_speed(float pumpspeed, bool continue_process);
  void start_self_test(void);
  void stop_self_test(void);
  String get_web_file(String fn, get_web_type type);
  void get_web_interface();
  float fromPower(float value);
  void SendMsg(const String& m, MESSAGE_TYPE msg_type);
  void handleAjaxSetup(AsyncWebServerRequest *request);
  #ifdef USE_LUA
  void start_lua_script();
  void load_lua_script();
  String get_lua_script_list();
  void run_lua_script(String fn);
  String run_lua_string(String lstr);
  #endif

  // filter out specific headers from the incoming request
  AsyncHeaderFilterMiddleware headerFilter;

uint16_t readPinsState() {// Функция для чтения состояния 16 пинов и возврата в виде слова (uint16_t)
  uint16_t pinsState = 0;
  
  // Первый байт (0-7)
  pinsState |= (digitalRead(WHEAD_LEVEL_SENSOR_PIN) ? 1 : 0) << 0;
  pinsState |= (digitalRead(WATERSENSOR_PIN) ? 1 : 0) << 1;
  pinsState |= (digitalRead(BTN_PIN) ? 1 : 0) << 2;
  pinsState |= (digitalRead(ALARM_BTN_PIN) ? 1 : 0) << 3;
  pinsState |= (digitalRead(RELE_CHANNEL1) ? 1 : 0) << 4;
  pinsState |= (digitalRead(RELE_CHANNEL2) ? 1 : 0) << 5;
  pinsState |= (digitalRead(RELE_CHANNEL3) ? 1 : 0) << 6;
  pinsState |= (digitalRead(RELE_CHANNEL4) ? 1 : 0) << 7;
  
  // Второй байт (8-15)
  pinsState |= (digitalRead(LUA_PIN) ? 1 : 0) << 8; 
  #if BOARD == ESP32S3
  pinsState |= (digitalRead(LUA_PIN2) ? 1 : 0) << 9; 
  pinsState |= (digitalRead(LUA_PIN3) ? 1 : 0) << 10;
  pinsState |= (digitalRead(BARDA_LEVEL_DWN) ? 1 : 0) << 11; 
  pinsState |= (digitalRead(BARDA_LEVEL_UP) ? 1 : 0) << 12; 
  #endif
  pinsState |= (PowerOn ? 1 : 0) << 13;
  pinsState |= (PauseOn ? 1 : 0) << 14;
  pinsState |= (SamSetup.UseBBuzzer ? 1 : 0) << 15;
 
  return pinsState;
}
String get_DSAddressListJson(String currentAddress) {//get_DSAddressListJson с использованием ArduinoJson
  DynamicJsonDocument doc(1024);
  JsonArray values = doc.createNestedArray("values");
  
  // Добавляем пустой элемент для "не выбран"
  values.add("");

  int selectedIndex = 0;
  
  for (uint8_t i = 0; i < DScnt; i++) {
    String addr = getDSAddress(DSAddr[i]);
    values.add(addr);
    
    if (currentAddress == addr) {
      selectedIndex = i + 1; // +1 потому что первый элемент - пустой
    }
  }
  
  doc["selected"] = selectedIndex;
  
  String json;
  serializeJson(doc, json);
  return json;
}
void parseCSVStringToInt8(const String& input, int8_t* output, uint8_t maxValues) {
    // Инициализируем выходной массив нулями
    for (uint8_t i = 0; i < maxValues; i++) {
        output[i] = 0;
    }
    
    uint8_t index = 0;
    int startPos = 0;
    int commaPos = input.indexOf(',');
    
    while (commaPos != -1 && index < maxValues) {
        String numStr = input.substring(startPos, commaPos);
        numStr.trim();
        
        if (numStr.length() > 0) {
            output[index] = numStr.toInt(); // toInt() вернет int, который преобразуется в int8_t
        }
        
        index++;
        startPos = commaPos + 1;
        commaPos = input.indexOf(',', startPos);
    }
    
    if (index < maxValues) {
        String numStr = input.substring(startPos);
        numStr.trim();
        if (numStr.length() > 0) {
            output[index] = numStr.toInt();
        }
    }
}
void parseCSVStringToUInt16(const String& input, uint16_t* output, uint8_t maxValues) {
    for (uint8_t i = 0; i < maxValues; i++) {
        output[i] = 0;
    }
    
    uint8_t index = 0;
    int startPos = 0;
    int commaPos = input.indexOf(',');
    
    while (commaPos != -1 && index < maxValues) {
        String numStr = input.substring(startPos, commaPos);
        numStr.trim();
        
        if (numStr.length() > 0) {
            output[index] = numStr.toInt();
        }
        
        index++;
        startPos = commaPos + 1;
        commaPos = input.indexOf(',', startPos);
    }
    
    if (index < maxValues) {
        String numStr = input.substring(startPos);
        numStr.trim();
        if (numStr.length() > 0) {
            output[index] = numStr.toInt();
        }
    }
}
void WebServerInit(void) {

  events.onConnect([](AsyncEventSourceClient * client) {
    client->send("hello!", NULL, millis(), 1000);
  });
  server.addHandler(&events);
  server.addHandler(new SPIFFSEditor(SPIFFS));
  server.onNotFound([](AsyncWebServerRequest * request) {
    Serial.printf("NOT_FOUND: ");
    if (request->method() == HTTP_GET)
      Serial.printf("GET");
    else if (request->method() == HTTP_POST)
      Serial.printf("POST");
    else if (request->method() == HTTP_DELETE)
      Serial.printf("DELETE");
    else if (request->method() == HTTP_PUT)
      Serial.printf("PUT");
    else if (request->method() == HTTP_PATCH)
      Serial.printf("PATCH");
    else if (request->method() == HTTP_HEAD)
      Serial.printf("HEAD");
    else if (request->method() == HTTP_OPTIONS)
      Serial.printf("OPTIONS");
    else
      Serial.printf("UNKNOWN");
    Serial.printf(" http://%s%s\n", request->host().c_str(), request->url().c_str());

    if (request->contentLength()) {
      Serial.printf("_CONTENT_TYPE: %s\n", request->contentType().c_str());
      Serial.printf("_CONTENT_LENGTH: %u\n", request->contentLength());
    }

    int headers = request->headers();
    int i;
    for (i = 0; i < headers; i++) {
      const AsyncWebHeader *h = request->getHeader(i);
      Serial.printf("_HEADER[%s]: %s\n", h->name().c_str(), h->value().c_str());
    }

    int params = request->params();
    for (i = 0; i < params; i++) {
      const AsyncWebParameter *p = request->getParam(i);
      if (p->isFile()) {
        Serial.printf("_FILE[%s]: %s, size: %u\n", p->name().c_str(), p->value().c_str(), p->size());
      } else if (p->isPost()) {
        Serial.printf("_POST[%s]: %s\n", p->name().c_str(), p->value().c_str());
      } else {
        Serial.printf("_GET[%s]: %s\n", p->name().c_str(), p->value().c_str());
      }
    }

    request->send(404);
  });
  server.onFileUpload([](AsyncWebServerRequest * request, const String & filename, size_t index, uint8_t *data, size_t len, bool final) {
    if (!index)
      Serial.printf("UploadStart: %s\n", filename.c_str());
    Serial.printf("%s", (const char *)data);
    if (final)
      Serial.printf("UploadEnd: %s (%u)\n", filename.c_str(), index + len);
  });
  server.onRequestBody([](AsyncWebServerRequest * request, uint8_t *data, size_t len, size_t index, size_t total) {
    if (!index)
      Serial.printf("BodyStart: %u\n", total);
    Serial.printf("%s", (const char *)data);
    if (index + len == total)
      Serial.printf("BodyEnd: %u\n", total);
  });
  server.on("/", HTTP_GET | HTTP_POST, [](AsyncWebServerRequest* request) {
    request->redirect("/index.htm");
  });
  server.serveStatic("/alarm.mp3", SPIFFS, "/alarm.mp3");
  server.serveStatic("/resetreason.css", SPIFFS, "/resetreason.css").setCacheControl("max-age=1");
  server.serveStatic("/data_old.csv", SPIFFS, "/data_old.csv").setCacheControl("max-age=1");
  server.serveStatic("/prg.csv", SPIFFS, "/prg.csv").setCacheControl("max-age=1");
  server.serveStatic("/state.csv", SPIFFS, "/state.csv").setCacheControl("max-age=1");
  server.serveStatic("/manual.htm", SPIFFS, "/manual.htm").setCacheControl("max-age=800");
  server.serveStatic("/pong.htm", SPIFFS, "/alarm.mp3");
  server.serveStatic("/program_fruit.txt", SPIFFS, "/program_fruit.txt").setCacheControl("max-age=1");
  server.serveStatic("/program_grain.txt", SPIFFS, "/program_grain.txt").setCacheControl("max-age=1");
  server.serveStatic("/program_shugar.txt", SPIFFS, "/program_shugar.txt").setCacheControl("max-age=1");

  server.on("/program.htm", HTTP_GET, [](AsyncWebServerRequest *request) {
    if(request->header("Accept-Encoding").indexOf("gzip") != -1 && SPIFFS.exists("/program.htm.gz")) {
      AsyncWebServerResponse *response = request->beginResponse(SPIFFS, "/program.htm.gz", "text/html");
      response->addHeader("Content-Encoding", "gzip");
      response->addHeader("Cache-Control", "max-age=1");
      request->send(response);
    } else {
      request->send(SPIFFS, "/program.htm", "text/html", false);
    }
  });
  server.on("/chart.htm", HTTP_GET, [](AsyncWebServerRequest *request) {
    if(request->header("Accept-Encoding").indexOf("gzip") != -1 && SPIFFS.exists("/chart.htm.gz")) {
      AsyncWebServerResponse *response = request->beginResponse(SPIFFS, "/chart.htm.gz", "text/html");
      response->addHeader("Content-Encoding", "gzip");
      response->addHeader("Cache-Control", "max-age=1");
      request->send(response);
    } else {
      request->send(SPIFFS, "/chart.htm", "text/html", false);
    }
  });
  server.on("/calibrate.htm", HTTP_GET, [](AsyncWebServerRequest *request) {
    if(request->header("Accept-Encoding").indexOf("gzip") != -1 && SPIFFS.exists("/calibrate.htm.gz")) {
      AsyncWebServerResponse *response = request->beginResponse(SPIFFS, "/calibrate.htm.gz", "text/html");
      response->addHeader("Content-Encoding", "gzip");
      response->addHeader("Cache-Control", "max-age=1");
      request->send(response);
    } else {
      request->send(SPIFFS, "/calibrate.htm", "text/html", false);
    }
  });
    server.on("/calibrate2.htm", HTTP_GET, [](AsyncWebServerRequest *request) {
    if(request->header("Accept-Encoding").indexOf("gzip") != -1 && SPIFFS.exists("/calibrate2.htm.gz")) {
      AsyncWebServerResponse *response = request->beginResponse(SPIFFS, "/calibrate2.htm.gz", "text/html");
      response->addHeader("Content-Encoding", "gzip");
      response->addHeader("Cache-Control", "max-age=1");
      request->send(response);
    } else {
      request->send(SPIFFS, "/calibrate2.htm", "text/html", false);
    }
  });
  server.on("/brewxml.htm", HTTP_GET, [](AsyncWebServerRequest *request) {
    if(request->header("Accept-Encoding").indexOf("gzip") != -1 && SPIFFS.exists("/brewxml.htm.gz")) {
      AsyncWebServerResponse *response = request->beginResponse(SPIFFS, "/brewxml.htm.gz", "text/html");
      response->addHeader("Content-Encoding", "gzip");
      response->addHeader("Cache-Control", "max-age=1");
      request->send(response);
    } else {
      request->send(SPIFFS, "/brewxml.htm", "text/html", false);
    }
  });
  server.on("/setup.htm", HTTP_GET, [](AsyncWebServerRequest *request) {
    if(request->header("Accept-Encoding").indexOf("gzip") != -1 && SPIFFS.exists("/setup.htm.gz")) {
      AsyncWebServerResponse *response = request->beginResponse(SPIFFS, "/setup.htm.gz", "text/html");
      response->addHeader("Content-Encoding", "gzip");
      response->addHeader("Cache-Control", "max-age=1");
      request->send(response);
    } else {
      if (SPIFFS.exists("/setup.htm")) request->send(SPIFFS, "/setup.htm", "text/html", false); else request->redirect("/technical");
    }
  });
  server.on("/style.css", HTTP_GET, [](AsyncWebServerRequest *request) {
    if(request->header("Accept-Encoding").indexOf("gzip") != -1 && SPIFFS.exists("/style.css.gz")) {
      AsyncWebServerResponse *response = request->beginResponse(SPIFFS, "/style.css.gz", "text/css");
      response->addHeader("Content-Encoding", "gzip");
      request->send(response);
    } else {
      request->send(SPIFFS, "/style.css", "text/css");
    }
  });
  server.on("/index.htm", HTTP_GET, [](AsyncWebServerRequest *request) {
    if (Samovar_Mode == SAMOVAR_BEER_MODE) {
      if(request->header("Accept-Encoding").indexOf("gzip") != -1 && SPIFFS.exists("/beer.htm.gz")) {
        AsyncWebServerResponse *response = request->beginResponse(SPIFFS, "/beer.htm.gz", "text/html");
        response->addHeader("Content-Encoding", "gzip");
        response->addHeader("Cache-Control", "max-age=1");
        request->send(response);
      } else {
        if (SPIFFS.exists("/beer.htm")) request->send(SPIFFS, "/beer.htm", "text/html", false); else request->redirect("/technical");
      }
    } else if (Samovar_Mode == SAMOVAR_DISTILLATION_MODE) {
      if(request->header("Accept-Encoding").indexOf("gzip") != -1 && SPIFFS.exists("/distiller.htm.gz")) {
        AsyncWebServerResponse *response = request->beginResponse(SPIFFS, "/distiller.htm.gz", "text/html");
        response->addHeader("Content-Encoding", "gzip");
        response->addHeader("Cache-Control", "max-age=1");
        request->send(response);
      } else {
       if (SPIFFS.exists("/distiller.htm")) request->send(SPIFFS, "/distiller.htm", "text/html", false); else request->redirect("/technical");
      }
    } else if (Samovar_Mode == SAMOVAR_BK_MODE) {
      if(request->header("Accept-Encoding").indexOf("gzip") != -1 && SPIFFS.exists("/bk.htm.gz")) {
        AsyncWebServerResponse *response = request->beginResponse(SPIFFS, "/bk.htm.gz", "text/html");
        response->addHeader("Content-Encoding", "gzip");
        response->addHeader("Cache-Control", "max-age=1");
        request->send(response);
      } else {
        if (SPIFFS.exists("/bk.htm")) request->send(SPIFFS, "/bk.htm", "text/html", false); else request->redirect("/technical");
      }
    } else if (Samovar_Mode == SAMOVAR_NBK_MODE) {
      if(request->header("Accept-Encoding").indexOf("gzip") != -1 && SPIFFS.exists("/nbk.htm.gz")) {
        AsyncWebServerResponse *response = request->beginResponse(SPIFFS, "/nbk.htm.gz", "text/html");
        response->addHeader("Content-Encoding", "gzip");
        response->addHeader("Cache-Control", "max-age=1");
        request->send(response);
      } else {
        if (SPIFFS.exists("/nbk.htm")) request->send(SPIFFS, "/nbk.htm", "text/html", false); else request->redirect("/technical");
      }
    } else {
      if(request->header("Accept-Encoding").indexOf("gzip") != -1 && SPIFFS.exists("/index.htm.gz")) {
        AsyncWebServerResponse *response = request->beginResponse(SPIFFS, "/index.htm.gz", "text/html");
        response->addHeader("Content-Encoding", "gzip");
        response->addHeader("Cache-Control", "max-age=1");
        request->send(response);
      } else {
        if (SPIFFS.exists("/index.htm")) request->send(SPIFFS, "/index.htm", "text/html", false); else request->redirect("/technical");
      }
    }  
  });
  server.on("/rrlog", HTTP_GET, [](AsyncWebServerRequest *request) {
    request->send(SPIFFS, "/resetreason.css", String());
  });
  server.on("/data.csv", HTTP_GET, [](AsyncWebServerRequest *request) {
    if (fileToAppend && fileToAppend.available())
      fileToAppend.flush();
    request->send(SPIFFS, "/data.csv", String());
  });
  server.on("/ajax", HTTP_GET, [](AsyncWebServerRequest *request) {
    static unsigned long timeout = millis();
    static String jsonstr; // 
    static String LastIP, IP;// Если прошло более 3 сек или прошлый клиент тот же готовим новый json, иначе отдаём прошлую заготовку, разгружаем сервер
    IP = request->client()->remoteIP().toString();
    if ((millis() - timeout >= 3000)||(LastIP == IP)|| (jsonstr.length()<30)) {
      timeout=millis();
      LastIP = IP;
      DynamicJsonDocument doc(1500); 
      doc["bt"] = format_float(bme_temp, 1);//bme_temp-all
      doc["bp"] = format_float(bme_pressure, 1);//bme_pressure-bk, cal2, dis, i
      doc["sp"] = format_float(start_pressure, 1);//start_pressure bk, dis
      doc["ST"] = format_float(SteamSensor.avgTemp, 2);//SteamTemp-all
      doc["PT"] = format_float(PipeSensor.avgTemp, 2);//PipeTemp-all
      doc["WT"] = format_float(WaterSensor.avgTemp, 2);//WaterTemp-all
      doc["TT"] = format_float(TankSensor.avgTemp, 2);//TankTemp-all+cal2
      doc["AT"] = format_float(ACPSensor.avgTemp, 2);//ACPTemp-all
      doc["AV"] = format_float(ActualVolumePerHour, 2);//ActualVolumePerHour-i, chart
      if (SamSetup.UsePump2 && Samovar_Mode == SAMOVAR_RECTIFICATION_MODE) {
        doc["AV1"] = format_float(ActualVolumePerHour2, 2); //ActualVolumePerHour
        doc["VA1"] = round(get_liquid_volume_by_step(stepper2.getCurrent())); //VolumeAll heads
      }
      if (Samovar_Mode == SAMOVAR_NBK_MODE) doc["SPd"] = format_float(get_liquid_rate_by_step(CurrentStepperSpeed), 2);//скорость подачи браги-nbk
      doc["B"] =String(readPinsState());
      if (Samovar_Mode == SAMOVAR_RECTIFICATION_MODE) {
         doc["cap"] =String(program[ProgramNum].capacity_num);
      }
      doc["VA"] = round(get_liquid_volume_by_step(stepper.getCurrent()));//VolumeAll-i, chart
      doc["WP"] = WthdrwlProgress; //WthdrwlProgress-all
      
      doc["WS"] = startval;//WthdrwlStatus-all
      doc["h"] = ESP.getFreeHeap(); // heap-all
      doc["r"] = WiFi.RSSI(); // rssi-all
      doc["f"] = total_byte - used_byte; //fr_bt -all
      doc["s"] = NTP.getFormattedTime((unsigned long)(millis() / 1000)); // stm-all
      doc["St"] = get_Samovar_Status(); // Status-all
      doc["L"] = Lua_status; // Lstatus-all
      // Условные блоки  
      if (Samovar_Mode == SAMOVAR_RECTIFICATION_MODE || 
          Samovar_Mode == SAMOVAR_BEER_MODE || 
          Samovar_Mode == SAMOVAR_DISTILLATION_MODE || 
          Samovar_Mode == SAMOVAR_NBK_MODE) {
        String pt = ""; // 
        if (SamovarStatusInt == 10 || SamovarStatusInt == 15 || (SamovarStatusInt == 2000 && PowerOn)) {
          pt = program[ProgramNum].WType; // 
        }
        doc["PTp"] = pt; // PrgType-beer, chart, i
      }
        if (hasMessages()) {
          MESSAGE_TYPE msgType;
          doc["Msg"] = MsgGet(&msgType);
          doc["msglvl"] = msgType;
        }

      if (LogMsg.length() > 0) {
        doc["LogMsg"] = LogMsg; // 
        LogMsg = ""; // 
      }

      if (SamSetup.PwrType != NO_POVER_REG) {
        doc["cpv"] = format_float(current_power_volt, 1); // current_power_volt-all
        doc["tpv"] = format_float(target_power_volt, 1); // target_power_volt-all
        if (current_power_mode == "0") doc["cpm"] = F("ON"); // режим регуляторов
        else if (current_power_mode == "1") doc["cpm"] = F("BOOST");
        else if (current_power_mode == "N") doc["cpm"] = F("OFF");
        else doc["cpm"] = F("NONE");
        //doc["cpm"] = current_power_mode; // current_power_mode-all
        doc["cpp"] = current_power_p; // current_power_p-all
      } else {
        doc["cpv"] = "0"; // current_power_volt
        doc["tpv"] = "0"; // target_power_volt
        doc["cpm"] = "NO REG"; // current_power_mode
        doc["cpp"] = 0; // current_power_p
      }

      if (SamSetup.UseWP) {
        doc["wps"] = water_pump_speed; // wp_spd-all
      }

      if (SamSetup.UseWS) {
        doc["WfR"] = format_float(WFflowRate, 1); // WFflowRate-i, dis, bk, nbk
        doc["WfT"] = WFtotalMilliLitres; // WFtotalMl-i, dis, bk, nbk
      }

      #if defined(USE_PRESSURE_XGZ) || defined(USE_PRESSURE_1WIRE) || defined(USE_PRESSURE_MPX)
       if (Samovar_Mode == SAMOVAR_RECTIFICATION_MODE || 
          Samovar_Mode == SAMOVAR_NBK_MODE) { doc["P"] = format_float(pressure_value, 2);} // pressure-i,nbk
      #endif

      if (Samovar_Mode == SAMOVAR_DISTILLATION_MODE) {
        doc["a"] = format_float(get_alcohol(TankSensor.avgTemp), 1); // alc-dist
        doc["sa"] = format_float(get_steam_alcohol(TankSensor.avgTemp), 1); // stm_alc-dist
      }

      if (PowerOn && Samovar_Mode == SAMOVAR_DISTILLATION_MODE) {
        doc["TR"] = String(int(timePredictor.remainingTime)); // TimeRemaining
        doc["Tt"] = String(int(timePredictor.predictedTotalTime)); // TotalTime
      }
      serializeJson(doc, jsonstr); // 
      vTaskDelay(2 / portTICK_PERIOD_MS); //
    }
    request->send(200, "application/json", jsonstr); // 
  });
  server.on("/ajax_setup", HTTP_GET, handleAjaxSetup);
 
  server.on("/command", HTTP_GET, [](AsyncWebServerRequest *request) {
    web_command(request);
  });
  server.on("/ajax_index", HTTP_GET, [](AsyncWebServerRequest *request) {
   DynamicJsonDocument doc(1500);
  
   // Обработка каждого ключа напрямую
   doc["btn_list"] = 
   #ifdef USE_LUA
     get_lua_script_list();
   #else
     "";
   #endif
    switch (SamSetup.PwrType) { // единицы измерений регуляторов
    case KVIC: case KVIC9600: case RMVK: {doc["pwr_unit"] = F("V");  break;}
    case STAB_AVR: case UNI_PROTOCOL: case MODBUS_RTU:{doc["pwr_unit"] = F("P"); break;}
    default:{ doc["pwr_unit"] = F("N"); break;}
   }
   doc["PipeColor"] = String(SamSetup.PipeColor);
   doc["SteamColor"] = String(SamSetup.SteamColor);
   doc["WaterColor"] = String(SamSetup.WaterColor);
   doc["TankColor"] = String(SamSetup.TankColor);
   doc["ACPColor"] = String(SamSetup.ACPColor);
   doc["Descr"] = SessionDescription;
  
   // Обработка WProgram в зависимости от режима
   if (Samovar_Mode == SAMOVAR_BEER_MODE) {
     doc["WProgram"] = get_beer_program();
   } else if (Samovar_Mode == SAMOVAR_DISTILLATION_MODE) {
     doc["WProgram"] = get_dist_program();
   } else if (Samovar_Mode == SAMOVAR_NBK_MODE) {
     doc["WProgram"] = get_nbk_program();
   } else {
     doc["WProgram"] = get_program(MAX_PRG);
   }
  
   doc["PWM_LV"] = String(SamSetup.PWM_L_V * 10);
   doc["PWM_V"] = String(bk_pwm);
   doc["v"] = SAMOVAR_VERSION;
   doc["StepperStep"] = String(STEPPER_MAX_SPEED); // 
   doc["StepperStepMl"] = String(SamSetup.StepperStepMl * 100); // 
  
   // Логика скрытия/показа элементов
   doc["SteamHide"] = (SteamSensor.avgTemp > 0) ? "false" : "true";
   doc["PipeHide"] = (PipeSensor.avgTemp > 0) ? "false" : "true";
   doc["WaterHide"] = (WaterSensor.avgTemp > 0) ? "false" : "true";
   doc["TankHide"] = (TankSensor.avgTemp > 0) ? "false" : "true";
   doc["PressureHide"] = (bme_pressure > 0) ? "false" : "true";
   doc["ProgNumHide"] = (ProgramNum > 0) ? "false" : "true";
  
   // Видео URL
   doc["videourl"] = String(SamSetup.videourl);
   doc["showvideo"] = (strlen(SamSetup.videourl) > 0) ? "inline" : "none";

   //String jsonstr;
   serializeJson(doc, jsonstr2);
   request->send(200, "application/json", jsonstr2);
  });
  server.on("/ajax_calibrate", HTTP_GET, [](AsyncWebServerRequest *request) {
   DynamicJsonDocument doc(500);
   doc["StepperStep"] = String(STEPPER_MAX_SPEED);
   doc["volume"] = Samovar_Mode == SAMOVAR_NBK_MODE ? "1000" : "100";
   doc["StepperStepMl"] = String(SamSetup.StepperStepMl * 100);
   //String jsonstr;
   serializeJson(doc, jsonstr2);
   request->send(200, "application/json", jsonstr2);
  });
  server.on("/program", HTTP_POST, [](AsyncWebServerRequest *request) {
    web_program(request);
    SavePrgToFS();
  });

  server.on("/calibrate", HTTP_GET, [](AsyncWebServerRequest *request) {
    calibrate_command(request);
  });

  server.on("/getlog", HTTP_GET, [](AsyncWebServerRequest *request) {
    get_data_log(request, "data.csv");
  });

  server.on("/getoldlog", HTTP_GET, [](AsyncWebServerRequest *request) {
    get_data_log(request, "data_old.csv");
  });
 #ifdef USE_LUA
  server.on("/lua", HTTP_GET, [](AsyncWebServerRequest *request) {
    start_lua_script();
    request->send(200, "text/html", "OK");
  });
 #endif
  server.on("/save", HTTP_POST, [](AsyncWebServerRequest *request) {
    DbgMsg("SAVE",1);
    handleSave(request);
  });
  server.onFileUpload([](AsyncWebServerRequest *request, const String &filename, size_t index, uint8_t *data, size_t len, bool final) {
    if (!index)
      DbgMsg("UploadStart: " + filename, 1);
    if (final)
      DbgMsg("UploadEnd: " + filename + String(index + len), 1);
  });
  server.onRequestBody([](AsyncWebServerRequest *request, uint8_t *data, size_t len, size_t index, size_t total) {
    if (!index)
      DbgMsg("BodyStart: " + String(total), 1);
    if (index + len == total)
      DbgMsg("BodyEnd: " + String(total),1);
  });
  DefaultHeaders::Instance().addHeader("Access-Control-Allow-Origin", "*");  // CORS
  headerFilter.filter("If-Modified-Since");
  //  DefaultHeaders::Instance().addHeader("Cache-Control", "no-cache");
  //  DefaultHeaders::Instance().addHeader("Pragma", "no-cache");
  //  DefaultHeaders::Instance().addHeader("Expires", "Thu, 01 Jan 1970 00:00:00 UTC");
  //  DefaultHeaders::Instance().addHeader("Last-Modified", "Mon, 03 Jan 2050 00:00:00 UTC");
  server.begin();
 DbgMsg("HTTP сервер запущен.",1);

 #ifndef NOT_USE_INTERFACE_UPDATE
  get_web_interface(); //запуск обновления интерфейса
 #endif
}
void handleAjaxSetup(AsyncWebServerRequest *request) {// Обработчик для отправки данных setup
  //AsyncResponseStream *response = request->beginResponseStream("application/json");
  DynamicJsonDocument doc(8192);
  // Режим работы
  doc["mode"] = SamSetup.Mode;

  // Основные параметры
  doc["DistTemp"] = format_float(SamSetup.DistTemp, 2);
  doc["DistTimeF"] = SamSetup.DistTimeF;
  doc["UsePreccureCorrect"] = SamSetup.UsePreccureCorrect ? 1 : 0;
  doc["UseHLS"] = SamSetup.UseHLS ? 1 : 0;
  doc["useautospeed"] = SamSetup.useautospeed ? 1 : 0;
  doc["autospeed"] = SamSetup.autospeed;
  doc["useautopowerdown"] = SamSetup.useautopowerdown ? 1 : 0;
  doc["MaxPressureValue"] = format_float(SamSetup.MaxPressureValue, 2);
  doc["UseBuzzer"] = SamSetup.UseBuzzer ? 1 : 0;
  doc["UseBBuzzer"] = SamSetup.UseBBuzzer ? 1 : 0;
  doc["ChangeProgramBuzzer"] = SamSetup.ChangeProgramBuzzer ? 1 : 0;

  // Температурные параметры
  doc["SteamColor"] = SamSetup.SteamColor;
  {
    DynamicJsonDocument addrDoc(1024);
    deserializeJson(addrDoc, get_DSAddressListJson(getDSAddress(SteamSensor.Sensor)));
    doc["SteamAddr"] = addrDoc;
  }
  doc["DeltaSteamTemp"] = format_float(SamSetup.DeltaSteamTemp, 2);
  doc["SetSteamTemp"] = format_float(SamSetup.SetSteamTemp, 2);
  doc["SteamDelay"] = SamSetup.SteamDelay;
  
  doc["PipeColor"] = SamSetup.PipeColor;
  {
    DynamicJsonDocument addrDoc(1024);
    deserializeJson(addrDoc, get_DSAddressListJson(getDSAddress(PipeSensor.Sensor)));
    doc["PipeAddr"] = addrDoc;
  }
  doc["DeltaPipeTemp"] = format_float(SamSetup.DeltaPipeTemp, 2);
  doc["SetPipeTemp"] = format_float(SamSetup.SetPipeTemp, 2);
  doc["PipeDelay"] = SamSetup.PipeDelay;
  
  doc["WaterColor"] = SamSetup.WaterColor;
  {
    DynamicJsonDocument addrDoc(1024);
    deserializeJson(addrDoc, get_DSAddressListJson(getDSAddress(WaterSensor.Sensor)));
    doc["WaterAddr"] = addrDoc;
  }
  doc["DeltaWaterTemp"] = format_float(SamSetup.DeltaWaterTemp, 2);
  doc["SetWaterTemp"] = format_float(SamSetup.SetWaterTemp, 2);
  doc["WaterDelay"] = SamSetup.WaterDelay;
  
  doc["TankColor"] = SamSetup.TankColor;
  {
    DynamicJsonDocument addrDoc(1024);
    deserializeJson(addrDoc, get_DSAddressListJson(getDSAddress(TankSensor.Sensor)));
    doc["TankAddr"] = addrDoc;
  }
  doc["DeltaTankTemp"] = format_float(SamSetup.DeltaTankTemp, 2);
  doc["SetTankTemp"] = format_float(SamSetup.SetTankTemp, 2);
  doc["TankDelay"] = SamSetup.TankDelay;
  
  doc["ACPColor"] = SamSetup.ACPColor;
  {
    DynamicJsonDocument addrDoc(1024);
    deserializeJson(addrDoc, get_DSAddressListJson(getDSAddress(ACPSensor.Sensor)));
    doc["ACPAddr"] = addrDoc;
  }
  doc["DeltaACPTemp"] = format_float(SamSetup.DeltaACPTemp, 2);
  doc["SetACPTemp"] = format_float(SamSetup.SetACPTemp, 2);
  doc["ACPDelay"] = SamSetup.ACPDelay;

  // Насос и PID
  doc["StepperStepMl"] = SamSetup.StepperStepMl;
  doc["Kp"] = format_float(SamSetup.Kp, 3);
  doc["Ki"] = format_float(SamSetup.Ki, 3);
  doc["Kd"] = format_float(SamSetup.Kd, 3);
  doc["StbVoltage"] = format_float(SamSetup.StbVoltage, 2);
  doc["BVolt"] = format_float(SamSetup.BVolt, 2);
  doc["UseST"] = SamSetup.UseST ? 1 : 0;

  // НБК
  doc["NbkIn"] = format_float(SamSetup.NbkIn, 2);
  doc["NbkDelta"] = format_float(SamSetup.NbkDelta, 2);
  doc["NbkDM"] = format_float(SamSetup.NbkDM, 2);
  doc["NbkDP"] = format_float(SamSetup.NbkDP, 2);
  doc["NbkSteamT"] = format_float(SamSetup.NbkSteamT, 2);
  doc["NbkOwPress"] = format_float(SamSetup.NbkOwPress, 2);
  doc["NBK_Mult_Pause"] = format_float(SamSetup.NBK_Mult_Pause, 2);  // количество инерций в качестве паузы после захлёба 
  doc["NBK_Pump_Limit"] = format_float(SamSetup.NBK_Pump_Limit, 2);  // максимальная производительность насоса браги для Оптимизации, л/ч 
  doc["Use_NBK_Delta_Pressure"] = SamSetup.Use_NBK_Delta_Pressure ? 1 : 0;            // Включение коррекции температуры барды по давлению в бардоотводчике
  doc["NBK_StepperStepMl"] = SamSetup.NBK_StepperStepMl;             // Количество шагов насоса НБК
  doc["Nbk_Tn"] = format_float(SamSetup.Nbk_Tn, 2);                  // Опорная Тн барды
 
  // NTC
  for (uint8_t i = 0; i < 5; i++) { // Поправки для термисторов
    String key = "NTC_dT" + String(i + 1);
    doc[key.c_str()] = format_float(SamSetup.NTC_dT[i], 2);
  } 
  String ADS;
  ADS.reserve(1024);
  ADS = String(SamSetup.m_adc[0]);
  for (uint8_t i=1; i<151; i++) { ADS += ", ";  ADS += String(SamSetup.m_adc[i]);}
  doc["m_adc"] = ADS;

  // Прочие
  doc["MQTT_Serv"] = SamSetup.MQTT_Serv;
  doc["blynkauth"] = SamSetup.blynkauth;
  doc["tgtoken"] = SamSetup.tg_token;
  doc["tgchatid"] = SamSetup.tg_chat_id;
  doc["videourl"] = SamSetup.videourl;
  doc["TimeZone"] = SamSetup.TimeZone;
  doc["CheckPower"] = SamSetup.CheckPower ? 1 : 0;
  doc["HeaterR"] = format_float(SamSetup.HeaterResistant, 3);
  doc["LogPeriod"] = SamSetup.LogPeriod;
  doc["UseWS"] = SamSetup.UseWS ? 1 : 0;

  // Реле
  doc["Rele1"] = SamSetup.rele1 ? 1 : 0;
  doc["Rele2"] = SamSetup.rele2 ? 1 : 0;
  doc["Rele3"] = SamSetup.rele3 ? 1 : 0;
  doc["Rele4"] = SamSetup.rele4 ? 1 : 0;

  // Настройки WiFi
  doc["SSID"] = SamSetup.SavedSSID;
  doc["PASS"] = SamSetup.SavedPASS;

  // Второй насос
  doc["UsePump2"] = SamSetup.UsePump2 ? 1 : 0;
  doc["SpPump2"] = SamSetup.SpPump2;
  
  // Настройки предельных значений для контроля автоматики
  doc["NBK_WPrc"] = format_float(SamSetup.NBK_WPrc, 2);// процент использования Mo и Po из оптимизации при переходе в работу.
  doc["Alrm_Wt_T"] = format_float(SamSetup.Alrm_Wt_T, 2);//Температура воды, при достижении которой будет оповещен оператор 70
  doc["Max_Wt_T"] = format_float(SamSetup.Max_Wt_T, 2);//Максимальное значение температуры воды, при котором выключится питание 75  
  doc["Max_St_T"] = format_float(SamSetup.Max_St_T, 2);//Максимальное значение температуры пара, при котором выключится питание 98.8
  doc["Max_ACP_T"] = format_float(SamSetup.Max_ACP_T, 2);//Максимальное значение температуры в ТСА, при котором выключится питание 75
  doc["Ch_Pwr_Md_St_T"] = format_float(SamSetup.Ch_Pwr_Md_St_T, 2);//Значение температуры датчика пара, при котором колонна перейдет из режима разгона в рабочий режим, а в режиме дистилляции при установленном датчике пара определит начало кипения 39
  doc["Opn_Vlv_Tnk_T"] = format_float(SamSetup.Opn_Vlv_Tnk_T, 2);//Значение температуры датчика в кубе, при котором откроется клапан подачи воды и включится насос подачи воды 77
  doc["D_Cls_Vlv"] = format_float(SamSetup.D_Cls_Vlv, 2);//Разность между заданной Т охлаждения воды и Т воды, до которой будет работать насос после завершения процесса перегонки в режимах дистилляции и ректификации 20
  doc["Heat_Dt"] = format_float(SamSetup.Heat_Dt, 2);//Разница между целевой температурой и текущей температурой (для режимов пиво и су-вид), до достяжения которой нагрев будет вестись на полную мощность (в режиме разгона).
  doc["Axlr_Heat_Dt"] = format_float(SamSetup.Axlr_Heat_Dt, 2);//Если разница между целевой температурой и текущей температурой (для режимов пиво и су-вид) больше заданной, то при использовании регулятора, управляемого по UART дополнительно Реле4 будет включать разгонный тэн, при разнице меньше разгонный тэн отключится
  doc["Boilng_T"] = format_float(SamSetup.Boilng_T, 2);//Температура кипения (для режима пиво) 98.9 
  doc["Trg_W_T"] = format_float(SamSetup.Trg_W_T, 2);//Температура воды, которую будет поддерживать ШИМ-регулятор. Так же, если при выключении питания температура воды будет меньше SamSetup.Trg_W_T - 15 отключится подача воды

  doc["PWM_L_V"] = SamSetup.PWM_L_V;//Нижнее значение (в процентах), для работы ШИМ-регулятора для насоса. Необходимо подобрать такое значение, которое обеспечивает поток воды 30
  doc["PWM_St_V"] = SamSetup.PWM_St_V;//Значение (в процентах), с которого начнет работать ШИМ-регулятор для насоса. Необходимо подобрать такое значение, которое гарантированно обеспечивает запуск мотора 40
  doc["PwrType"] = SamSetup.PwrType;// Модель регулятора напряжения/мощности 0-нет, 1-KVIC, 2-KVIC 9600 бод, 3- RMVK, 4 - StabAVR/регулятор от Dranek, 5 - Universal protocol, 6 - Modbus RTU (частотники)
  doc["PwStartPause"] = SamSetup.PwStartPause;//задержка перед отправкой команды на разгон регулятору. Нужна для конфигурации, когда регулятор включается контактором, чтобы регулятор успел запуститься, ms
  doc["Ws_Calbr"] = SamSetup.Ws_Calbr;//К-т калибровки датчика потока F=98*Q(L/min), для другого датчика необходимо установить другое значение.
  doc["BlynkUrl"] = SamSetup.BlynkUrl;//использовать бесплатный сервер Blynk samovar-tool.ru  вместо облачного Blynk
    ADS = String(SamSetup.servoDelta[0]);
  for (uint8_t i=1; i<11; i++) ADS += ", " + String(SamSetup.servoDelta[i]);
  doc["servoDelta"] = ADS;//Корректировка для угла поворота сервопривода.
  doc["Use_BMP180"] = SamSetup.Use_BMP180 ? 1 : 0; //использовать датчик давления BMP180/BMP085
  doc["UseBlynk"] = SamSetup.UseBlynk ? 1 : 0; //использовать Blynk в проекте
  doc["UseBTN"] = SamSetup.UseBTN ? 1 : 0; //использовать кнопку
  doc["UseA_BTN"] = SamSetup.UseA_BTN ? 1 : 0;//использовать аварийную кнопку. Нажатие на нее останавливает подачу воды и отключает питание. 
  doc["UseMQTT"] = SamSetup.UseMQTT ? 1 : 0;//использовать сохранение логов в облако. 
  doc["UseDS"] = SamSetup.UseDS ? 1 : 0; //использовать в проекте DS18B20
  doc["UseNTC"] = SamSetup.UseNTC ? 1 : 0; //использовать в проекте термисторы
  doc["DUFnpn"] = SamSetup.DUFnpn ? 1 : 0;  //использовать датчик уровня жидкости N-P-N
  doc["UseTg"] = SamSetup.UseTg ? 1 : 0;//отправлять уведомления в телеграм, для этого в настройках необходимо указать токен бота и идентификатор пользователя.
  doc["UseBdT_Aset"] = SamSetup.UseBdT_Aset ? 1 : 0;//использовать автоматическую коррекцию Т тела для первой программы отбора тела или предзахлеба после голов, а также для программы предзахлеба, если она стоит раньше предпоследней программы отбора тела или предзахлеба
  doc["StRev1"] = SamSetup.StRev1 ? 1 : 0;//изменить направление врашения шагового двигателя 1
  doc["StRev2"] = SamSetup.StRev2 ? 1 : 0;//изменить направление врашения шагового двигателя 2 
  doc["UseWP"] = SamSetup.UseWP ? 1 : 0;// водяной насос
  doc["UseWV"] = SamSetup.UseWV;// водяной клапан
 
  // Вентилятор
  doc["PWM_Cull"] = SamSetup.PWM_Cull ? 1 : 0;                // Включение куллера охлаждения корпуса
  doc["Cull_N_Min"] = SamSetup.Cull_N_Min;          // минимальные обороты, %
  doc["Cull_N_Max"] = SamSetup.Cull_N_Max;          // максимальные обороты, %
  doc["Cull_T_ON"] = SamSetup.Cull_T_ON;              // Т включения
  doc["Cull_T_Max"] = SamSetup.Cull_T_Max;             // T максимальных оборотов

  doc["dbg"] = SamSetup.dbg ? 1 : 0; 
  doc["MQTT_User"] = SamSetup.MQTT_User; 
  doc["MQTT_Pass"] = SamSetup.MQTT_Pass; 
  doc["MQTT_Port"] = SamSetup.MQTT_Port;
  
  serializeJson(doc, jsonstr2);
  request->send(200, "application/json", jsonstr2);
}
void handleSave(AsyncWebServerRequest *request) { //прием и сохранение SamSetup

  if (request->hasParam("plain", true)) {
    jsonstr2 = request->getParam("plain", true)->value();
    DbgMsg("Begin save",1);
    DynamicJsonDocument doc(5000);
    DeserializationError error = deserializeJson(doc, jsonstr2);
    DbgMsg("deserializeJson",1);
    if (error) {
      DbgMsg("JSON parse error: " + String(error.c_str()),1);
      request->send(400, "text/plain", "Invalid JSON");
      return;
    }
    // Вентилятор
   
    if (doc.containsKey("PWM_Cull")) SamSetup.PWM_Cull = doc["PWM_Cull"].as<uint8_t>();
    if (doc.containsKey("Cull_N_Min")) SamSetup.Cull_N_Min = doc["Cull_N_Min"].as<uint16_t>(); 
    if (doc.containsKey("Cull_N_Max")) SamSetup.Cull_N_Max = doc["Cull_N_Max"].as<uint16_t>();
    if (doc.containsKey("Cull_T_ON")) SamSetup.Cull_T_ON = doc["Cull_T_ON"].as<float>();
    if (doc.containsKey("Cull_T_Max")) SamSetup.Cull_T_Max = doc["Cull_T_Max"].as<float>();
    if (!SamSetup.PWM_Cull) Culler_PWM.write(0);

    if (doc.containsKey("UseWP")) SamSetup.UseWP = doc["UseWP"].as<uint8_t>();//водяной насос и клапан
    if (!SamSetup.UseWP) pump_pwm.write(0);
    if (doc.containsKey("UseWV"))  SamSetup.UseWV = doc["UseWV"].as<uint8_t>();

    // Обработка числовых параметров
    if (doc.containsKey("SteamDelay")) SamSetup.SteamDelay = doc["SteamDelay"].as<uint16_t>();
    if (doc.containsKey("PipeDelay")) SamSetup.PipeDelay = doc["PipeDelay"].as<uint16_t>();
    if (doc.containsKey("WaterDelay")) SamSetup.WaterDelay = doc["WaterDelay"].as<uint16_t>();
    if (doc.containsKey("TankDelay")) SamSetup.TankDelay = doc["TankDelay"].as<uint16_t>();
    if (doc.containsKey("ACPDelay")) SamSetup.ACPDelay = doc["ACPDelay"].as<uint16_t>();         
    if (doc.containsKey("MQTT_Port")) SamSetup.MQTT_Port = doc["MQTT_Port"].as<uint16_t>();
    // Обработка float параметров
    if (doc.containsKey("DeltaSteamTemp")) SamSetup.DeltaSteamTemp = doc["DeltaSteamTemp"].as<float>();
    if (doc.containsKey("DeltaPipeTemp")) SamSetup.DeltaPipeTemp = doc["DeltaPipeTemp"].as<float>();
    if (doc.containsKey("DeltaWaterTemp")) SamSetup.DeltaWaterTemp = doc["DeltaWaterTemp"].as<float>();
    if (doc.containsKey("DeltaTankTemp")) SamSetup.DeltaTankTemp = doc["DeltaTankTemp"].as<float>();
    if (doc.containsKey("DeltaACPTemp")) SamSetup.DeltaACPTemp = doc["DeltaACPTemp"].as<float>();
    if (doc.containsKey("SetSteamTemp")) SamSetup.SetSteamTemp = doc["SetSteamTemp"].as<float>();
    if (doc.containsKey("SetPipeTemp")) SamSetup.SetPipeTemp = doc["SetPipeTemp"].as<float>();
    if (doc.containsKey("SetWaterTemp")) SamSetup.SetWaterTemp = doc["SetWaterTemp"].as<float>();
    if (doc.containsKey("SetTankTemp")) SamSetup.SetTankTemp = doc["SetTankTemp"].as<float>();
    if (doc.containsKey("SetACPTemp")) SamSetup.SetACPTemp = doc["SetACPTemp"].as<float>();
    if (doc.containsKey("Kp")) SamSetup.Kp = doc["Kp"].as<float>();
    if (doc.containsKey("Ki")) SamSetup.Ki = doc["Ki"].as<float>();
    if (doc.containsKey("Kd")) SamSetup.Kd = doc["Kd"].as<float>();
    if (doc.containsKey("StbVoltage")) SamSetup.StbVoltage = doc["StbVoltage"].as<float>();
    if (doc.containsKey("BVolt")) SamSetup.BVolt = doc["BVolt"].as<float>();
    if (doc.containsKey("MaxPressureValue")) SamSetup.MaxPressureValue = doc["MaxPressureValue"].as<float>();
    if (doc.containsKey("DistTemp")) SamSetup.DistTemp = doc["DistTemp"].as<float>();
    if (doc.containsKey("HeaterR")) SamSetup.HeaterResistant = doc["HeaterR"].as<float>();
    if (doc.containsKey("NbkIn")) SamSetup.NbkIn = doc["NbkIn"].as<float>();
    if (doc.containsKey("NbkDelta")) SamSetup.NbkDelta = doc["NbkDelta"].as<float>();
    if (doc.containsKey("NbkDM")) SamSetup.NbkDM = doc["NbkDM"].as<float>();
    if (doc.containsKey("NbkDP")) SamSetup.NbkDP = doc["NbkDP"].as<float>();
    if (doc.containsKey("NbkSteamT")) SamSetup.NbkSteamT = doc["NbkSteamT"].as<float>();
    if (doc.containsKey("NbkOwPress")) SamSetup.NbkOwPress = doc["NbkOwPress"].as<float>();
    if (doc.containsKey("SpPump2")) SamSetup.SpPump2 = doc["SpPump2"].as<float>();
    if (doc.containsKey("NBK_Mult_Pause")) SamSetup.NBK_Mult_Pause = doc["NBK_Mult_Pause"].as<float>();  // количество инерций в качестве паузы после захлёба 
    if (doc.containsKey("NBK_Pump_Limit")) SamSetup.NBK_Pump_Limit = doc["NBK_Pump_Limit"].as<float>();  // Включение коррекции температуры барды по давлению в бардоотводчике
    if (doc.containsKey("Nbk_Tn")) SamSetup.Nbk_Tn = doc["Nbk_Tn"].as<float>();                          // Опорная Тн барды
    
    if (doc.containsKey("NBK_WPrc")) SamSetup.NBK_WPrc = doc["NBK_WPrc"].as<float>();// процент использования Mo и Po из оптимизации при переходе в работу.
    if (doc.containsKey("Alrm_Wt_T")) SamSetup.Alrm_Wt_T = doc["Alrm_Wt_T"].as<float>();//Температура воды, при достижении которой будет оповещен оператор 70
    if (doc.containsKey("Max_Wt_T")) SamSetup.Max_Wt_T = doc["Max_Wt_T"].as<float>();//Максимальное значение температуры воды, при котором выключится питание 75  
    if (doc.containsKey("Max_St_T")) SamSetup.Max_St_T = doc["Max_St_T"].as<float>();//Максимальное значение температуры пара, при котором выключится питание 98.8
    if (doc.containsKey("Max_ACP_T")) SamSetup.Max_ACP_T = doc["Max_ACP_T"].as<float>();//Максимальное значение температуры в ТСА, при котором выключится питание 75
    if (doc.containsKey("Ch_Pwr_Md_St_T")) SamSetup.Ch_Pwr_Md_St_T = doc["Ch_Pwr_Md_St_T"].as<float>();//Значение температуры датчика пара, при котором колонна перейдет из режима разгона в рабочий режим, а в режиме дистилляции при установленном датчике пара определит начало кипения 39
    if (doc.containsKey("Opn_Vlv_Tnk_T")) SamSetup.Opn_Vlv_Tnk_T = doc["Opn_Vlv_Tnk_T"].as<float>();//Значение температуры датчика в кубе, при котором откроется клапан подачи воды и включится насос подачи воды 77
    if (doc.containsKey("D_Cls_Vlv")) SamSetup.D_Cls_Vlv = doc["D_Cls_Vlv"].as<float>();//Разность между заданной Т охлаждения воды и Т воды, до которой будет работать насос после завершения процесса перегонки в режимах дистилляции и ректификации 20
    if (doc.containsKey("Heat_Dt")) SamSetup.Heat_Dt = doc["Heat_Dt"].as<float>();//Разница между целевой температурой и текущей температурой (для режимов пиво и су-вид), до достяжения которой нагрев будет вестись на полную мощность (в режиме разгона).
    if (doc.containsKey("Axlr_Heat_Dt")) SamSetup.Axlr_Heat_Dt = doc["Axlr_Heat_Dt"].as<float>();//Если разница между целевой температурой и текущей температурой (для режимов пиво и су-вид) больше заданной, то при использовании регулятора, управляемого по UART дополнительно Реле4 будет включать разгонный тэн, при разнице меньше разгонный тэн отключится
    if (doc.containsKey("Boilng_T")) SamSetup.Boilng_T = doc["Boilng_T"].as<float>();//Температура кипения (для режима пиво) 98.9 
    if (doc.containsKey("Trg_W_T")) SamSetup.Trg_W_T = doc["Trg_W_T"].as<float>();//Температура воды, которую будет поддерживать ШИМ-регулятор. Так же, если при выключении питания температура воды будет меньше SamSetup.Trg_W_T - 15 отключится подача воды

    // Обработка целочисленных параметров
    if (doc.containsKey("DistTimeF")) SamSetup.DistTimeF = doc["DistTimeF"].as<uint8_t>();
    if (doc.containsKey("StepperStepMl")) SamSetup.StepperStepMl = doc["StepperStepMl"].as<uint16_t>();
    if (doc.containsKey("TimeZone")) SamSetup.TimeZone = doc["TimeZone"].as<uint8_t>();
    if (doc.containsKey("LogPeriod")) SamSetup.LogPeriod = doc["LogPeriod"].as<uint8_t>();
    if (doc.containsKey("autospeed")) SamSetup.autospeed = doc["autospeed"].as<uint8_t>();
    if (doc.containsKey("NBK_StepperStepMl")) SamSetup.NBK_StepperStepMl = doc["NBK_StepperStepMl"].as<uint16_t>(); // Количество шагов насоса на мл
    
    if (doc.containsKey("PWM_L_V")) SamSetup.PWM_L_V = doc["PWM_L_V"].as<uint8_t>();
    if (doc.containsKey("PWM_St_V")) SamSetup.PWM_St_V = doc["PWM_St_V"].as<uint8_t>();
    
    if (doc.containsKey("PwrType")) {
      uint8_t PWRT_temp= doc["PwrType"].as<uint8_t>(); 
      if (SamSetup.PwrType != PWRT_temp) {
        SamSetup.PwrType = PWRT_temp;
        is_reboot = true;
      }
    }
    if (doc.containsKey("PwStartPause")) SamSetup.PwStartPause = doc["PwStartPause"].as<uint16_t>();
    if (doc.containsKey("Ws_Calbr")) SamSetup.Ws_Calbr = doc["Ws_Calbr"].as<uint16_t>();

    // Обработка boolean параметров
    if (doc.containsKey("UseHLS")) SamSetup.UseHLS = doc["UseHLS"].as<uint8_t>();
    if (doc.containsKey("UsePreccureCorrect")) SamSetup.UsePreccureCorrect = doc["UsePreccureCorrect"].as<uint8_t>();
    if (doc.containsKey("useautopowerdown")) SamSetup.useautopowerdown = doc["useautopowerdown"].as<uint8_t>();
    if (doc.containsKey("useautospeed")) SamSetup.useautospeed = doc["useautospeed"].as<uint8_t>();
    if (doc.containsKey("ChangeProgramBuzzer")) SamSetup.ChangeProgramBuzzer = doc["ChangeProgramBuzzer"].as<uint8_t>();
    if (doc.containsKey("UseBuzzer")) SamSetup.UseBuzzer = doc["UseBuzzer"].as<uint8_t>();
    if (doc.containsKey("UseBBuzzer")) SamSetup.UseBBuzzer = doc["UseBBuzzer"].as<uint8_t>();
    if (doc.containsKey("UseWS")) SamSetup.UseWS = doc["UseWS"].as<uint8_t>();
    if (doc.containsKey("UseST")) SamSetup.UseST = doc["UseST"].as<uint8_t>();
    if (doc.containsKey("CheckPower")) SamSetup.CheckPower = doc["CheckPower"].as<uint8_t>();
    if (doc.containsKey("UsePump2")) SamSetup.UsePump2 = doc["UsePump2"].as<uint8_t>();
    if (doc.containsKey("Use_NBK_Delta_Pressure")) SamSetup.Use_NBK_Delta_Pressure = doc["Use_NBK_Delta_Pressure"].as<uint8_t>();

    if (doc.containsKey("Use_BMP180")) SamSetup.Use_BMP180 = doc["Use_BMP180"].as<uint8_t>();
    if (doc.containsKey("UseBlynk")) {
      uint8_t UseBlynk_tmp = doc["UseBlynk"].as<uint8_t>();
      if (UseBlynk_tmp != SamSetup.UseBlynk) {
        SamSetup.UseBlynk = UseBlynk_tmp;
        is_reboot += UseBlynk_tmp;
      }
    }    
    if (doc.containsKey("UseBTN")) SamSetup.UseBTN = doc["UseBTN"].as<uint8_t>();    
    if (doc.containsKey("UseA_BTN")) SamSetup.UseA_BTN = doc["UseA_BTN"].as<uint8_t>();    
    if (doc.containsKey("UseMQTT")) { 
      uint8_t UseMQTT_tmp = doc["UseMQTT"].as<uint8_t>();
      if (UseMQTT_tmp != SamSetup.UseMQTT) {
        SamSetup.UseMQTT =  UseMQTT_tmp;
        is_reboot += UseMQTT_tmp; //перезагрузка при включении
        } 
      }  
    if (doc.containsKey("UseDS")) SamSetup.UseDS = doc["UseDS"].as<uint8_t>();   
    if (doc.containsKey("UseNTC")) SamSetup.UseNTC = doc["UseNTC"].as<uint8_t>();    
    if (doc.containsKey("DUFnpn")) SamSetup.DUFnpn = doc["DUFnpn"].as<uint8_t>();    
    if (doc.containsKey("UseTg")) {
        uint8_t UseTg_tmp = doc["UseTg"].as<uint8_t>(); 
        if (SamSetup.UseTg != UseTg_tmp) {
          SamSetup.UseTg = UseTg_tmp;
          is_reboot += UseTg_tmp;
        }
      }
    if (doc.containsKey("UseBdT_Aset")) SamSetup.UseBdT_Aset = doc["UseBdT_Aset"].as<uint8_t>(); 
    if (doc.containsKey("StRev1")) SamSetup.StRev1 = doc["StRev1"].as<uint8_t>(); 
    if (doc.containsKey("StRev2")) SamSetup.StRev2 = doc["StRev2"].as<uint8_t>(); 
    if (doc.containsKey("dbg")) SamSetup.dbg = doc["dbg"].as<uint8_t>(); 
    // Обработка строковых параметров
    if (doc.containsKey("videourl")) strlcpy(SamSetup.videourl, doc["videourl"].as<const char*>(), sizeof(SamSetup.videourl));
    if (doc.containsKey("blynkauth")) strlcpy(SamSetup.blynkauth, doc["blynkauth"].as<const char*>(), sizeof(SamSetup.blynkauth));
    if (doc.containsKey("tgtoken")) strlcpy(SamSetup.tg_token, doc["tgtoken"].as<const char*>(), sizeof(SamSetup.tg_token));
    if (doc.containsKey("tgchatid")) strlcpy(SamSetup.tg_chat_id, doc["tgchatid"].as<const char*>(), sizeof(SamSetup.tg_chat_id));
    if (doc.containsKey("SteamColor")) strlcpy(SamSetup.SteamColor, doc["SteamColor"].as<const char*>(), sizeof(SamSetup.SteamColor));
    if (doc.containsKey("PipeColor")) strlcpy(SamSetup.PipeColor, doc["PipeColor"].as<const char*>(), sizeof(SamSetup.PipeColor));
    if (doc.containsKey("WaterColor")) strlcpy(SamSetup.WaterColor, doc["WaterColor"].as<const char*>(), sizeof(SamSetup.WaterColor));
    if (doc.containsKey("TankColor")) strlcpy(SamSetup.TankColor, doc["TankColor"].as<const char*>(), sizeof(SamSetup.TankColor));
    if (doc.containsKey("ACPColor")) strlcpy(SamSetup.ACPColor, doc["ACPColor"].as<const char*>(), sizeof(SamSetup.ACPColor));
    if (doc.containsKey("SSID")) strlcpy(SamSetup.SavedSSID, doc["SSID"].as<const char*>(), sizeof(SamSetup.SavedSSID));
    if (doc.containsKey("PASS")) strlcpy(SamSetup.SavedPASS, doc["PASS"].as<const char*>(), sizeof(SamSetup.SavedPASS));
    if (doc.containsKey("MQTT_Serv")) strlcpy(SamSetup.MQTT_Serv, doc["MQTT_Serv"].as<const char*>(), sizeof(SamSetup.MQTT_Serv));
    if (doc.containsKey("MQTT_User")) strlcpy(SamSetup.MQTT_User, doc["MQTT_User"].as<const char*>(), sizeof(SamSetup.MQTT_User));
    if (doc.containsKey("MQTT_Pass")) strlcpy(SamSetup.MQTT_Pass, doc["MQTT_Pass"].as<const char*>(), sizeof(SamSetup.MQTT_Pass));
    if (doc.containsKey("BlynkUrl")) strlcpy(SamSetup.BlynkUrl, doc["BlynkUrl"].as<const char*>(), sizeof(SamSetup.BlynkUrl));

    // Обработка реле
     if (doc.containsKey("Rele1")) SamSetup.rele1 = doc["Rele1"].as<uint8_t>();
     if (doc.containsKey("Rele2")) SamSetup.rele2 = doc["Rele2"].as<uint8_t>();
     if (doc.containsKey("Rele3")) SamSetup.rele3 = doc["Rele3"].as<uint8_t>();
     if (doc.containsKey("Rele4")) SamSetup.rele4 = doc["Rele4"].as<uint8_t>();

    // Обработка адресов датчиков
     if (doc.containsKey("SteamAddr")) {
    int index = doc["SteamAddr"].as<int>();
        if (index > 0) CopyDSAddress(DSAddr[index-1], SamSetup.SteamAdress); else SamSetup.SteamAdress[0]=0;
      }

     if (doc.containsKey("PipeAddr")) {
    int index = doc["PipeAddr"].as<int>();
        if (index >0) CopyDSAddress(DSAddr[index-1], SamSetup.PipeAdress); else SamSetup.PipeAdress[0]=0;
      }

     if (doc.containsKey("WaterAddr")) {
    int index = doc["WaterAddr"].as<int>();
        if (index > 0) CopyDSAddress(DSAddr[index-1], SamSetup.WaterAdress); else SamSetup.WaterAdress[0]=0;
      }

     if (doc.containsKey("TankAddr")) {
    int index = doc["TankAddr"].as<int>();
        if (index > 0) CopyDSAddress(DSAddr[index-1], SamSetup.TankAdress); else SamSetup.TankAdress[0]=0;
    }

     if (doc.containsKey("ACPAddr")) {
    int index = doc["ACPAddr"].as<int>();
        if (index > 0) CopyDSAddress(DSAddr[index-1], SamSetup.ACPAdress); else SamSetup.ACPAdress[0]=0;
    }
    for (uint8_t i = 0; i < 5; i++) { // Поправки для термисторов
      String key = "NTC_dT" + String(i + 1);
      if (doc.containsKey(key.c_str())) SamSetup.NTC_dT[i] = doc[key.c_str()].as<float>(); 
    } 
    if (doc.containsKey("servoDelta")) { //Корректировка для угла поворота сервопривода.
      String str = doc["servoDelta"].as<String>();
      parseCSVStringToInt8(str, SamSetup.servoDelta, 11);
    }  
    if (doc.containsKey("m_adc")) {
        String adcString = doc["m_adc"].as<String>();
        parseCSVStringToUInt16(adcString, SamSetup.m_adc, 151);
    }
        // Обработка режима работы
   if (doc.containsKey("mode")) {
    SAMOVAR_MODE newMode = doc["mode"].as<SAMOVAR_MODE>();
    if (SamSetup.Mode != newMode && newMode>=0 && newMode < 5) {
      if (SamovarStatusInt != 0)   {
        SendMsg(F("Попытка сменить режим при запущенном процессе! Отмена смены режима."), ALARM_MSG);
          } else {
           SamSetup.Mode = newMode;
           Samovar_Mode = newMode;
           Samovar_CR_Mode = newMode;
           program_init();//Инициализация программы для изменившегося режима
          } 
        }
    }
    DbgMsg("save param",1);
     // Отправляем ответ
  ValidateSamSetup(); //Проверка на допустимость пределов значений
  UseSamSetup();     //Инициализация использования новых значений  
  save_profile();     // Сохраняем настройки во флэш 
  if (SamSetup.DUFnpn)  whls.setType(HIGH_PULL); else  whls.setType(LOW_PULL);  //Задаем параметры для сенсора уровня флегмы  
  DbgMsg("End",1);
  request->send(200, "text/plain", "Settings saved");
 } else {
  request->send(400, "text/plain", "No data received");
 }   
 vTaskDelay(10/ portTICK_PERIOD_MS);
  if (is_reboot) {
  ESP.restart();
  }
}
void web_command(AsyncWebServerRequest *request) {
  // Защита от повторных команд
  static uint32_t last_command_time = 0;
  if (millis() - last_command_time < 1500) {
    request->send(200, "text/plain", "OK");
    return;
  }
  last_command_time = millis();
  if (request->params() == 1) {
    if (request->hasArg("start") && PowerOn) {
      if (Samovar_Mode == SAMOVAR_BEER_MODE) {
        sam_command_sync = SAMOVAR_BEER_NEXT;
      } else if (Samovar_Mode == SAMOVAR_DISTILLATION_MODE) {
        sam_command_sync = SAMOVAR_DIST_NEXT;
      } else if (Samovar_Mode == SAMOVAR_NBK_MODE) {
        sam_command_sync = SAMOVAR_NBK_NEXT;
      } else {
        sam_command_sync = SAMOVAR_START;
      }
    } else if (request->hasArg("power")) {
      if (Samovar_Mode == SAMOVAR_BEER_MODE) {
        if (!PowerOn) sam_command_sync = SAMOVAR_BEER;
        else
          sam_command_sync = SAMOVAR_POWER;
      } else if (Samovar_Mode == SAMOVAR_DISTILLATION_MODE) {
        if (!PowerOn) sam_command_sync = SAMOVAR_DISTILLATION;
        else
          sam_command_sync = SAMOVAR_POWER;
      } else if (Samovar_Mode == SAMOVAR_BK_MODE) {
        if (!PowerOn) sam_command_sync = SAMOVAR_BK;
        else
          sam_command_sync = SAMOVAR_POWER;
      } else if (Samovar_Mode == SAMOVAR_NBK_MODE) {
        if (!PowerOn) sam_command_sync = RUN_NBK;
        else
          sam_command_sync = SAMOVAR_POWER;
      } else
        sam_command_sync = SAMOVAR_POWER;
    } else if (request->hasArg("setbodytemp")) {
      sam_command_sync = SAMOVAR_SETBODYTEMP;
    } else if (request->hasArg("reset")) {
      sam_command_sync = SAMOVAR_RESET;
    } else if (request->hasArg("reboot")) {
      ESP.restart();
    } else if (request->hasArg("resetwifi")) {
      reset_wifi();
    } else if (request->hasArg("startst")) {
      sam_command_sync = SAMOVAR_SELF_TEST;
    } else if (request->hasArg("rescands")) {
      if (SamSetup.UseDS) scan_ds_adress();
      if (SamSetup.UseNTC) NTC_Init();      
    } else if (request->hasArg("stopst")) {
      stop_self_test();
    } else if (request->hasArg("mixer")) {
      if (request->arg("mixer").toInt() == 1) {
        set_mixer(true);
      } else {
        set_mixer(false);
      }
    } else if (request->hasArg("pnbk") && PowerOn) {
      if (request->arg("pnbk").toInt() == 9000) { //TODO повышаем скорость насоса на один шаг
        set_stepper_target(CurrentStepperSpeed + get_speed_from_rate(float(SamSetup.NbkDP), SamSetup.NBK_StepperStepMl), 0, 2147483640);
        } else if (request->arg("pnbk").toInt() == 8000) { //TODO понижаем скорость насоса на один шаг
          if (CurrentStepperSpeed - get_speed_from_rate(float(SamSetup.NbkDP), SamSetup.NBK_StepperStepMl) <= 0) {
            set_stepper_target(0, 0, 0);
          } else {
            set_stepper_target(CurrentStepperSpeed - get_speed_from_rate(float(SamSetup.NbkDP), SamSetup.NBK_StepperStepMl), 0, 2147483640);
          }
        } else if (request->arg("pnbk").toFloat() >= 0 && request->arg("pnbk").toInt() < 40) { // TODO устанавливаем заказанную скорость насоса
          set_stepper_target(get_speed_from_rate(float(request->arg("pnbk").toFloat()), SamSetup.NBK_StepperStepMl), 0, 2147483640);

        }
      } else if (request->hasArg("nbkopt") && PowerOn) { //TODO устанавливаем текущие М и Р как оптимальные Мо и Ро
        nbk_Mo = nbk_M;
        nbk_Po = nbk_P;
        SendMsg("Установлены оптимальные значения: " + String(fromPower(nbk_Mo),0) + String(PwrSign) + ",  " + String(nbk_Po,1) + " л/ч", WARNING_MSG);
    } else if (request->hasArg("distiller")) {
      if (request->arg("distiller").toInt() == 1) {
        sam_command_sync = SAMOVAR_DISTILLATION;
      } else {
        sam_command_sync = SAMOVAR_POWER;
      }
    } else if (request->hasArg("startbk")) {
      if (request->arg("startbk").toInt() == 1) {
        sam_command_sync = SAMOVAR_BK;
      } else {
        sam_command_sync = SAMOVAR_POWER;
      }
    } else if (request->hasArg("startnbk")) {
      if (request->arg("startnbk").toInt() == 1) {
        sam_command_sync = RUN_NBK;
      } else {
        sam_command_sync = SAMOVAR_POWER;
      }
    } else if (request->hasArg("watert")) {
      set_water_temp(request->arg("watert").toFloat());
    } else if (request->hasArg("pumpspeed")) {
      set_pump_speed(get_speed_from_rate(request->arg("pumpspeed").toFloat(), SamSetup.StepperStepMl), true);
    } else if (request->hasArg("pspd2")) {
      set_pump2_speed(get_speed_from_rate(request->arg("pspd2").toFloat(), SamSetup.StepperStepMl), true);
    } else if (request->hasArg("setcap")) {
      int8_t d_cap = request->arg("setcap").toInt();
      if (program[ProgramNum].capacity_num == 0 && d_cap == -1) d_cap=0;
      if (program[ProgramNum].capacity_num == 10 && d_cap == 1) d_cap=0;
      program[ProgramNum].capacity_num += d_cap;
      set_capacity(program[ProgramNum].capacity_num);
    } else if (request->hasArg("pause")) {
      if (PauseOn) {
        sam_command_sync = SAMOVAR_CONTINUE;
      } else {
        sam_command_sync = SAMOVAR_PAUSE;
      }
    }
    else if (request->hasArg("voltage") && SamSetup.PwrType != NO_POVER_REG) {
      set_current_power(request->arg("voltage").toFloat());
    }
    else if (request->hasArg("servo") && SamSetup.PwrType != NO_POVER_REG) {
      setServoAngle(request->arg("servo").toInt());
    }
 #ifdef USE_LUA
    else if (request->hasArg("lua")) {
      run_lua_script(request->arg("lua"));
    } else if (request->hasArg("luastr")) {
      String lstr = request->arg("luastr");
      lstr.replace("^", " ");
      run_lua_string(lstr);
    }
 #endif
  }
  request->send(200, "text/plain", "OK");
}
void web_program(AsyncWebServerRequest *request) {
  if (request->hasArg("WProgram")) {
    if (Samovar_Mode == SAMOVAR_BEER_MODE) {
      set_beer_program(request->arg("WProgram"));
      request->send(200, "text/plain", get_beer_program());
    } else if (Samovar_Mode == SAMOVAR_DISTILLATION_MODE) {
      set_dist_program(request->arg("WProgram"));
      request->send(200, "text/plain", get_dist_program());
    } else if (Samovar_Mode == SAMOVAR_NBK_MODE) {
      set_nbk_program(request->arg("WProgram"));
      request->send(200, "text/plain", get_nbk_program());
    } else {
      set_program(request->arg("WProgram"));
      request->send(200, "text/plain", get_program(MAX_PRG));
    }
  }
  if (request->hasArg("Descr")) {
    SessionDescription = request->arg("Descr");
    SessionDescription.replace("%", "&#37;");
  }
}
void calibrate_command(AsyncWebServerRequest *request) {
  bool cl = false;
  if (request->params() >= 1) {
    if (request->hasArg("stpstep")) {
      CurrentStepperSpeed = request->arg("stpstep").toInt();
    }
    if (request->hasArg("start") && startval == 0) {
      sam_command_sync = CALIBRATE_START;
    }
    if (request->hasArg("finish") && startval == 100) {
      sam_command_sync = CALIBRATE_STOP;
      cl = true;
    }
  }
  vTaskDelay(5 / portTICK_PERIOD_MS);
  if (cl) {
    int s = (Samovar_Mode == SAMOVAR_NBK_MODE ? SamSetup.NBK_StepperStepMl * 1000 : SamSetup.StepperStepMl * 100); 
    request->send(200, "text/plain", (String)s);
  } else
    request->send(200, "text/plain", "OK");
}
void get_data_log(AsyncWebServerRequest *request, String fn) {
  if (fileToAppend && fileToAppend.available())
    fileToAppend.flush();
  AsyncWebServerResponse *response;
  if (SPIFFS.exists("/" + fn)) {
    response = request->beginResponse(SPIFFS, "/" + fn, String(), true);
  } else {
    response = request->beginResponse(400, "text/plain", "");
  }
  response->addHeader(F("Content-Type"), F("application/octet-stream"));
  response->addHeader(F("Content-Description"), F("File Transfer"));
  response->addHeader(F("Content-Disposition"), "attachment; filename=\"" + fn + "\"");
  response->addHeader(F("Pragma"), F("public"));
  response->addHeader(F("Cache-Control"), F("no-cache"));
  request->send(response);
}
void get_web_interface() {
     SerialMsg("Free space:" + String(SPIFFS.totalBytes()), 1);
  bool ret = Ping.ping("web.samovar-tool.ru", 2);
  if (!ret) {
    SerialMsg(F("Нет покдлючения к интернету. Не удалось проверить обновление интерфейса. Если это первичная установка - необходимо загрузить интерфейс в Самоварыч в соответствии с инструкцией"),1);
    return;
  }
  String version;
  String local_version;
  String s = "";
  version = get_web_file("version.txt", GET_CONTENT);
  if (version == "<ERR>") return;
  SerialMsg("WEB interface version = " + String(version),1);
  File fn = SPIFFS.open("/version.txt", FILE_READ);
  if (fn) {
    local_version = fn.readStringUntil('\n');
    fn.close();
  }
  SerialMsg("Local interface version = " + String(local_version), 1);
  if (version != local_version) {
    s += get_web_file("index.htm", SAVE_FILE_OVERRIDE);
    s += get_web_file("alarm.mp3", SAVE_FILE_OVERRIDE);
    s += get_web_file("style.css", SAVE_FILE_OVERRIDE);
    s += get_web_file("beer.htm", SAVE_FILE_OVERRIDE);
    s += get_web_file("bk.htm", SAVE_FILE_OVERRIDE);
    s += get_web_file("nbk.htm", SAVE_FILE_OVERRIDE);
    s += get_web_file("brewxml.htm", SAVE_FILE_OVERRIDE);
    s += get_web_file("calibrate.htm", SAVE_FILE_OVERRIDE);
    s += get_web_file("chart.htm", SAVE_FILE_OVERRIDE);
    s += get_web_file("distiller.htm", SAVE_FILE_OVERRIDE);
    s += get_web_file("edit.htm", SAVE_FILE_OVERRIDE);
    s += get_web_file("program.htm", SAVE_FILE_OVERRIDE);
    s += get_web_file("setup.htm", SAVE_FILE_OVERRIDE);
    s += get_web_file("beer.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("bk.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("nbk.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("dist.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("init.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("rectificat.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("script.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("btn_rect_button1.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("btn_rect_button2.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("btn_beer_button1.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("btn_beer_button2.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("btn_dist_button1.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("btn_dist_button2.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("btn_bk_button1.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("btn_bk_button2.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("btn_nbk_button1.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("btn_nbk_button2.lua", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("program_fruit.txt", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("program_grain.txt", SAVE_FILE_IF_NOT_EXIST);
    s += get_web_file("program_shugar.txt", SAVE_FILE_IF_NOT_EXIST);
    if (s.length() == 0) {
      s = get_web_file("version.txt", SAVE_FILE_OVERRIDE);
    }
  }
}
String get_web_file(String fn, get_web_type type) {
  if (type == SAVE_FILE_IF_NOT_EXIST && SPIFFS.exists("/" + fn)) {
    SerialMsg("File " + fn + " already exist.",1);
    return "";
  }
  String url = "http://web.samovar-tool.ru/" + String(SAMOVAR_VERSION) + "/" + fn + "?" + micros();
  SerialMsg("url = " + url, 1);
  String s = http_sync_request_get(url);
  if (s == "<ERR>") {
    return s;
  } else {
    if (type == GET_CONTENT) {
      return s;
    } else {
      File wf = SPIFFS.open("/" + fn, FILE_WRITE);
      wf.print(s);
      wf.close();
     // DbgMsg("responseText = " + s,1);
     if (SPIFFS.exists("/" + fn)) SerialMsg("File exists",1); else SerialMsg("File not exists",1);
     SerialMsg("Free space:" + String(SPIFFS.totalBytes()-SPIFFS.usedBytes()),1);
    }
    SerialMsg("Done (L=" + String(s.length()) + ")",1);
  }
  return "";
}
String http_sync_request_get(String url) {
  asyncHTTPrequest request;
  request.setDebug(false);
  request.setTimeout(8); // Таймаут восемь секунд
  request.open("GET", url.c_str());
  unsigned long startTime = millis();
  while (request.readyState() < 1) {
    if (millis() - startTime > 4000) { // Общий таймаут 8 секунд
      DbgMsg("Timeout: readyState never reached 1",1);
      return "<ERR>";
    }
    vTaskDelay(25 / portTICK_PERIOD_MS);
  }
  vTaskDelay(150 / portTICK_PERIOD_MS);
  request.send();
  vTaskDelay(150 / portTICK_PERIOD_MS);
  // Таймаут для ожидания завершения запроса (readyState == 4)
  startTime = millis();
  while (request.readyState() != 4) {
    if (millis() - startTime > 2000) { // Таймаут 4 секунд
      DbgMsg("Timeout: request not completed within 4 seconds",1);
      return "<ERR>";
    }
    vTaskDelay(25 / portTICK_PERIOD_MS);
  }
  vTaskDelay(60 / portTICK_PERIOD_MS);
  if (request.responseHTTPcode() >= 0) {
    if (request.responseHTTPcode() != 200) {
    DbgMsg(F("responseHTTPcode = "),1);
    DbgMsg(String(request.responseHTTPcode()),1);
    DbgMsg("Content " + url + " download error",1);
      return "<ERR>";
    }
    return request.responseText();
  } else {
    DbgMsg(F("responseHTTPcode = "),1);
    DbgMsg(String(request.responseHTTPcode()),1);
    DbgMsg("Content " + url + " download error (2)",1);
    return "<ERR>";
  }  
  return "";
}
String http_sync_request_post(String url, String body, String ContentType) {
  asyncHTTPrequest request;
  request.setDebug(false);
  request.setTimeout(8);  //Таймаут восемь секунд
  request.open("POST", url.c_str());  //URL
  unsigned long startTime = millis();
  while (request.readyState() < 1) {
    if (millis() - startTime > 4000) { // Общий таймаут 8 секунд
      DbgMsg("Timeout: readyState never reached 1",1);
      return "<ERR>";
    }
    vTaskDelay(25 / portTICK_PERIOD_MS);
  }
  vTaskDelay(150 / portTICK_PERIOD_MS);
  request.setReqHeader("Content-Type", getValue(ContentType, ':', 1).c_str());
  request.send(body);
  startTime = millis();
  while (request.readyState() != 4) {
    if (millis() - startTime > 2000) { // Таймаут 4 секунд
      DbgMsg("Timeout: request not completed within 4 seconds",1);
      return "<ERR>";
    }
    vTaskDelay(25 / portTICK_PERIOD_MS);
  }
  vTaskDelay(60 / portTICK_PERIOD_MS);
  if (request.responseHTTPcode() >= 0) {
    return request.responseText();
  } else {
    return "<ERR>";
  }
}
void onWsEvent(AsyncWebSocket *server, AsyncWebSocketClient *client, AwsEventType type, void *arg, uint8_t *data, size_t len) {
  if (type == WS_EVT_CONNECT) {
    Serial.printf("ws[%s][%u] connect\n", server->url(), client->id());
    client->printf("Hello Client %u :)", client->id());
    client->ping();
  } else if (type == WS_EVT_DISCONNECT) {
    Serial.printf("ws[%s][%u] disconnect\n", server->url(), client->id());
  } else if (type == WS_EVT_ERROR) {
    Serial.printf("ws[%s][%u] error(%u): %s\n", server->url(), client->id(), *((uint16_t *)arg), (char *)data);
  } else if (type == WS_EVT_PONG) {
    Serial.printf("ws[%s][%u] pong[%u]: %s\n", server->url(), client->id(), len, (len) ? (char *)data : "");
  } else if (type == WS_EVT_DATA) {
    AwsFrameInfo *info = (AwsFrameInfo *)arg;
    String msg = "";
    if (info->final && info->index == 0 && info->len == len) {
      //the whole message is in a single frame and we got all of it's data
      Serial.printf("ws[%s][%u] %s-message[%llu]: ", server->url(), client->id(), (info->opcode == WS_TEXT) ? "text" : "binary", info->len);

      if (info->opcode == WS_TEXT) {
        for (size_t i = 0; i < info->len; i++) {
          msg += (char)data[i];
        }
      } else {
        char buff[4];
        for (size_t i = 0; i < info->len; i++) {
          sprintf(buff, "%02x ", (uint8_t)data[i]);
          msg += buff;
        }
      }
      Serial.printf("%s\n", msg.c_str());

      if (info->opcode == WS_TEXT)
        client->text(F("I got your text message"));
      else
        client->binary(F("I got your binary message"));
    } else {
      //message is comprised of multiple frames or the frame is split into multiple packets
      if (info->index == 0) {
        if (info->num == 0)
          Serial.printf("ws[%s][%u] %s-message start\n", server->url(), client->id(), (info->message_opcode == WS_TEXT) ? "text" : "binary");
        Serial.printf("ws[%s][%u] frame[%u] start[%llu]\n", server->url(), client->id(), info->num, info->len);
      }

      Serial.printf("ws[%s][%u] frame[%u] %s[%llu - %llu]: ", server->url(), client->id(), info->num, (info->message_opcode == WS_TEXT) ? "text" : "binary", info->index, info->index + len);

      if (info->opcode == WS_TEXT) {
        for (size_t i = 0; i < len; i++) {
          msg += (char)data[i];
        }
      } else {
        char buff[4];
        for (size_t i = 0; i < len; i++) {
          sprintf(buff, "%02x ", (uint8_t)data[i]);
          msg += buff;
        }
      }
      Serial.printf("%s\n", msg.c_str());

      if ((info->index + len) == info->len) {
        Serial.printf("ws[%s][%u] frame[%u] end[%llu]\n", server->url(), client->id(), info->num, info->len);
        if (info->final) {
          Serial.printf("ws[%s][%u] %s-message end\n", server->url(), client->id(), (info->message_opcode == WS_TEXT) ? "text" : "binary");
          if (info->message_opcode == WS_TEXT)
            client->text(F("I got your text message"));
          else
            client->binary(F("I got your binary message"));
        }
      }
    }
  }
}