#pragma once
#ifndef __SAMOVAR_I_H_
#define __SAMOVAR_I_H_
#include <Arduino.h>
//**************************************************************************************************************
// Параметры
//**************************************************************************************************************
#define SAMOVAR_HOST "samovarich"
//**************************************************************************************************************
#define defaultSSID  "" // Ваша точка доступа №1
#define defaultPass  "" // Пароль от неё
#define WiFiAP_Pass  "12345678" //Можно поменять пароль точки доступа

//#define USE_DISPLAY //Использовать oled дисплей I2C 128*64
#define USE_DISP_LC // Использовать LiquidCrystal 20*4
//**************************************************************************************************************
// Выбор используемой платы ESP32
//**************************************************************************************************************
#define BOARD DEVKIT
//#define BOARD ESP32S3
//**************************************************************************************************************
bool Setup_Key = 4; //ключ актуальности настроек для первичной загрузки (0-255), можно поменять для переинициализации

//**************************************************************************************************************
// Настройки использования подсистем Самовара
//**************************************************************************************************************

//#define USE_UPDATE_OTA                       //использовать ArduinoOTA для обновления через WI-FI. Удобно при отладке, при работе создает лишнюю нагрузку на ESP32
                                             //рекомендую отключить, при этом нужно перед открытием скетча в IDE скопировать в папку с прошивкой
                                             //соответствующий файл partations.csv из подпапки /partation_shemes
//#define USE_LUA                              //использовать lua для написания скриптов для управления Самоваром,
                                             //тоже рекомендую отключить если не пользуетесь, прилично добавит стабильности

//Определение типа используемого датчика давления. Может быть использован только один тип. 
//#define USE_PRESSURE_XGZ 32                  //использовать датчик давления XGZP6897D (или аналогичный). Какое использовать значение - смотреть параметр К в таблице: https://github.com/fanfanlatulipe26/XGZP6897D 
#define USE_PRESSURE_1WIRE {0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x55}  //использовать датчик давления по 1Wire

// адреса датчиков температур по умолчанию (сейчас здесь адреса Измерителя)
const uint8_t STEAM_ADRESS[8] = {0x28, 0x10, 0x55, 0x44, 0x33, 0x22, 0x01, 0xd8};
const uint8_t PIPE_ADRESS[8]  = {0x28, 0x10, 0x55, 0x44, 0x33, 0x22, 0x02, 0xd7};
const uint8_t WATER_ADRESS[8] = {0x28, 0x10, 0x55, 0x44, 0x33, 0x22, 0x04, 0xc9};
const uint8_t TANK_ADRESS[8]  = {0x28, 0x10, 0x55, 0x44, 0x33, 0x22, 0x03, 0xd2};
const uint8_t ACP_ADRESS[8]   = {0x28, 0x10, 0x55, 0x44, 0x33, 0x22, 0x05, 0xcc};

//#define USE_STEPPER_ACCELERATION              //использовать плавный старт и торможение шагового двигателя

#define NOT_USE_INTERFACE_UPDATE              //не использовать обновление интерфейса при загрузке
// У Самоварыча нет своего файлсервера и врядли будет, файлы заливать вручную с помощью техстраницы, если файлов нет она откроется вместо главной,
// там если файловая система не готова жмём Format FS, 
// затем жмём Выбрать файлы, заходим в \data, Ctrl+A, Ok, Upload selected. Перезагружаем Самоварыча.
#endif
