"""
Точка входа в приложение
"""
import sys
from PySide6.QtWidgets import QApplication
from terminal_window import FinalTerminal
from utils import get_timestamp

def main():
    app = QApplication(sys.argv)
    app.setApplicationName("COM Терминал PRO с эмуляторами")
    
    # Стиль
    app.setStyle("Fusion")
    
    window = FinalTerminal()
    window.show()
    
    # Подключаем сигналы от SerialManager
    window.serial_manager.data_received.connect(window.process_received_data)
    window.serial_manager.binary_received.connect(window.process_received_binary)
    window.serial_manager.status_changed.connect(
        lambda msg: window.terminal.append(f"{get_timestamp(True)}{msg}")
    )
    
    sys.exit(app.exec())

if __name__ == "__main__":
    main()