"""
Инициализация модуля вкладок
"""

def create_all_emulator_tabs(tab_widget, parent):
    """Создать все вкладки эмуляторов"""
    from .rmvk_tab import RMVKTab
    from .kvic_tab import KVICTab
    from .stab_avr_tab import StabAVRTab
    from .universal_tab import UniversalTab
    from .modbus_tab import ModbusTab
    from .udp_tab import UDPTab
    
    emulator_tabs = [
        ("RMVK", RMVKTab, "📟 РМВК"),
        ("KVIC9600", KVICTab, "⚡ КВИК 9600"),
        ("STAB_AVR", StabAVRTab, "🎚️ Stab AVR"),
        ("UNI_PROTOCOL", UniversalTab, "🌐 Uni"),
        ("MODBUS_RTU", ModbusTab, "🔢 MODBUS"),
        ("UDP_STAB", UDPTab, "📡 UDP"),
    ]
    
    for emulator_name, tab_class, tab_title in emulator_tabs:
        tab = tab_class(parent, emulator_name)
        tab_widget.addTab(tab, tab_title)