"""
Вкладка эмулятора КВИК
"""
from PySide6.QtWidgets import *
from .emulator_tab_base import EmulatorTabBase

class KVICTab(EmulatorTabBase):
    def __init__(self, parent, emulator_name):
        super().__init__(parent, emulator_name)
        self.emulator = parent.emulator_manager.emulators.get(emulator_name)
    
    def setup_ui(self):
        """Настройка интерфейса КВИК"""
        layout = QHBoxLayout(self)
        layout.setContentsMargins(5, 5, 5, 5)
        layout.setSpacing(10)
        
        # Колонка 1: Управление
        col1 = self.create_control_column()
        layout.addLayout(col1, 1)
        
        # Колонка 2: Настройки
        col2 = self.create_settings_column()
        layout.addLayout(col2, 2)
        
        # Колонка 3: Состояние
        col3 = self.create_state_column()
        layout.addLayout(col3, 3)
        
        # Колонка 4: Быстрые команды
        col4 = self.create_commands_column()
        layout.addLayout(col4, 1)
    
    def get_state_info(self):
        if not self.emulator:
            return "Эмулятор не найден"
        
        state_info = f"Состояние: {'Включен' if self.emulator.enabled else 'Выключен'}\n\n"
        
        state_info += f"Текущее напряжение: {getattr(self.emulator, 'current_voltage', 0):.1f} В\n"
        state_info += f"Целевое напряжение: {getattr(self.emulator, 'target_voltage', 0):.1f} В\n"
        state_info += f"Режим: {getattr(self.emulator, 'mode', '2')}\n"
        state_info += f"Состояние: {'Включен' if getattr(self.emulator, 'power_on', False) else 'Выключен'}\n"
        state_info += f"Семистор: {'ПРОБИТ' if getattr(self.emulator, 'triac_shorted', False) else 'Исправен'}\n"
        
        return state_info
    
    def get_quick_commands(self):
        return [
            ("T", "📊", "Запрос состояния"),
            ("S14A", "3️⃣", "Установить 33.0В"),
            ("S1C2", "4️⃣", "Установить 45.0В"),
            ("M0", "⚙️", "Режим работы"),
            ("M2", "💤", "Режим сна")
        ]