"""
Вкладка эмулятора Modbus RTU
"""
from PySide6.QtWidgets import *
from .emulator_tab_base import EmulatorTabBase

class ModbusTab(EmulatorTabBase):
    def __init__(self, parent, emulator_name):
        super().__init__(parent, emulator_name)
        self.emulator = parent.emulator_manager.emulators.get(emulator_name)
    
    def setup_ui(self):
        """Настройка интерфейса Modbus"""
        layout = QHBoxLayout(self)
        layout.setContentsMargins(5, 5, 5, 5)
        layout.setSpacing(5)
        
        # Колонка 1: Управление
        col1 = self.create_control_column()
        layout.addLayout(col1, 1)
        
        # Колонка 2: Настройки
        col2 = self.create_settings_column()
        
        # Дополнительные настройки для Modbus
        modbus_group = QGroupBox()
        modbus_group.setMinimumHeight(85)  # Увеличиваем высоту группы
        modbus_layout = QVBoxLayout(modbus_group)
        modbus_layout.setContentsMargins(2, 2, 2, 2)  # Увеличиваем отступы сверху
        
        self.hex_check = QCheckBox("HEX отображение")
        self.hex_check.setChecked(True)
        self.hex_check.stateChanged.connect(self.update_hex_display)
        modbus_layout.addWidget(self.hex_check)
        
        reg_layout = QGridLayout()
        reg_layout.setVerticalSpacing(1)
        reg_layout.setHorizontalSpacing(3)
        
        reg_layout.addWidget(QLabel("Регистры входной:"), 0, 0)
        self.reg_in_spin = QSpinBox()
        self.reg_in_spin.setRange(0, 100)
        self.reg_in_spin.setValue(10)
        self.reg_in_spin.setMaximumWidth(70)
        self.reg_in_spin.valueChanged.connect(self.update_input_registers)
        reg_layout.addWidget(self.reg_in_spin, 0, 1)
        
        reg_layout.addWidget(QLabel("выходной:"), 1, 0)
        self.reg_out_spin = QSpinBox()
        self.reg_out_spin.setRange(0, 100)
        self.reg_out_spin.setValue(10)
        self.reg_out_spin.setMaximumWidth(70)
        self.reg_out_spin.valueChanged.connect(self.update_output_registers)
        reg_layout.addWidget(self.reg_out_spin, 1, 1)
        
        modbus_layout.addLayout(reg_layout)
        modbus_layout.addStretch()
        col2.addWidget(modbus_group)
        
        layout.addLayout(col2, 2)
        
        # Колонка 3: Состояние
        col3 = self.create_state_column()
        layout.addLayout(col3, 3)
        
        # Колонка 4: Быстрые команды
        col4 = self.create_commands_column()
        layout.addLayout(col4, 1)
    
    def get_state_info(self):
        if not self.emulator:
            return "Эмулятор не найден"
        
        state_info = f"Состояние: {'Включен' if self.emulator.enabled else 'Выключен'}\n\n"
        
        state_info += f"Адрес устройства: {getattr(self.emulator, 'address', 10)}\n"
        state_info += f"Запущен: {'Да' if getattr(self.emulator, 'started', False) else 'Нет'}\n"
        state_info += f"Семистор: {'ПРОБИТ' if getattr(self.emulator, 'triac_shorted', False) else 'Исправен'}\n"
        
        if hasattr(self.emulator, 'registers'):
            state_info += "Регистры:\n"
            registers = getattr(self.emulator, 'registers', {})
            for addr, value in list(registers.items())[:5]:
                state_info += f"  0x{addr:04X}: 0x{value:04X} ({value})\n"
            if len(registers) > 5:
                state_info += f"  ... и ещё {len(registers) - 5}\n"
        
        return state_info
    
    def get_quick_commands(self):
        return [
            ("0A0300000001", "📖", "Чтение регистра 0"),
            ("0A0300010001", "📖", "Чтение регистра 1"),
            ("0A0600011388", "✏️", "Запись 5000 в регистр 1"),
            ("0A10000100010203E8", "📝", "Запись 1000 в регистры")
        ]
    
    def update_hex_display(self, state):
        # Логика для переключения HEX отображения
        pass
    
    def update_input_registers(self, value):
        # Логика обновления входных регистров
        pass
    
    def update_output_registers(self, value):
        # Логика обновления выходных регистров
        pass