"""
Вкладка эмулятора РМВК
"""
from PySide6.QtWidgets import *
from .emulator_tab_base import EmulatorTabBase

class RMVKTab(EmulatorTabBase):
    def __init__(self, parent, emulator_name):
        super().__init__(parent, emulator_name)
        self.emulator = parent.emulator_manager.emulators.get(emulator_name)
    
    def setup_ui(self):
        """Настройка интерфейса РМВК"""
        layout = QHBoxLayout(self)
        layout.setContentsMargins(5, 5, 5, 5)
        layout.setSpacing(10)
        
        # Колонка 1: Управление
        col1 = self.create_control_column()
        layout.addLayout(col1, 1)
        
        # Колонка 2: Настройки
        col2 = self.create_settings_column()
        layout.addLayout(col2, 2)
        
        # Колонка 3: Состояние
        col3 = self.create_state_column()
        layout.addLayout(col3, 3)
        
        # Колонка 4: Быстрые команды
        col4 = self.create_commands_column()
        layout.addLayout(col4, 1)
    
    def get_state_info(self):
        if not self.emulator:
            return "Эмулятор не найден"
        
        state_info = f"Состояние: {'Включен' if self.emulator.enabled else 'Выключен'}\n"
        
        state_info += f"Напряжение сети: {getattr(self.emulator, 'voltage_in', 0)} В\n"
        state_info += f"Выходное напряжение: {getattr(self.emulator, 'voltage_out', 0)} В\n"
        state_info += f"Установленное напряжение: {getattr(self.emulator, 'voltage_set', 0)} В\n"
        state_info += f"Питание: {'ON' if getattr(self.emulator, 'power_on', False) else 'OFF'}\n"
        state_info += f"Режим: {getattr(self.emulator, 'mode', '0')}\n\n"
        
        # Информация о семисторе
        if getattr(self.emulator, 'triac_shorted', False):
            state_info += f"Семистор: ПРОБИТ\n"
            state_info += f"Макс. напряжение: {getattr(self.emulator, 'triac_max_voltage', 250)} В\n"
        else:
            state_info += f"Семистор: Исправен\n"
            state_info += f"Макс. напряжение: {getattr(self.emulator, 'normal_max_voltage', 230)} В\n"
        
        # Память
        state_info += f"\nПамять:\n"
        for i in range(min(5, len(getattr(self.emulator, 'memory', [])))):
            state_info += f"  M{i}: {getattr(self.emulator, 'memory', [])[i]} В\n"
        
        return state_info
    
    def get_quick_commands(self):
        return [
            ("AT+VI?", "🔌", "Напряжение сети"),
            ("AT+VO?", "⚡", "Выходное напряжение"),
            ("AT+VS?", "🎯", "Установленное напряжение"),
            ("AT+ON=1", "▶", "Включить питание"),
            ("AT+ON=0", "⏹", "Выключить питание")
        ]