"""
Вкладка универсального протокола
"""
from PySide6.QtWidgets import *
from .emulator_tab_base import EmulatorTabBase

class UniversalTab(EmulatorTabBase):
    def __init__(self, parent, emulator_name):
        super().__init__(parent, emulator_name)
        self.emulator = parent.emulator_manager.emulators.get(emulator_name)
    
    def setup_ui(self):
        """Настройка интерфейса Universal"""
        layout = QHBoxLayout(self)
        layout.setContentsMargins(5, 5, 5, 5)
        layout.setSpacing(10)
        
        # Колонка 1: Управление
        col1 = self.create_control_column()
        layout.addLayout(col1, 1)
        
        # Колонка 2: Настройки
        col2 = self.create_settings_column()
        layout.addLayout(col2, 2)
        
        # Колонка 3: Состояние
        col3 = self.create_state_column()
        layout.addLayout(col3, 3)
        
        # Колонка 4: Быстрые команды
        col4 = self.create_commands_column()
        layout.addLayout(col4, 1)
    
    def get_state_info(self):
        if not self.emulator:
            return "Эмулятор не найден"
        
        state_info = f"Состояние: {'Включен' if self.emulator.enabled else 'Выключен'}\n\n"
        
        state_info += f"Основное значение: {getattr(self.emulator, 'main_value', 0)}\n"
        state_info += f"Вспомогательное значение: {getattr(self.emulator, 'aux_value', 0)}\n"
        state_info += f"Режим: {getattr(self.emulator, 'mode', 0)}\n"
        state_info += f"Напряжение сети: {getattr(self.emulator, 'network_voltage', 220)} В\n"
        state_info += f"Соединение: {'Есть' if getattr(self.emulator, 'connected', True) else 'Нет'}\n"
        state_info += f"Семистор: {'ПРОБИТ' if getattr(self.emulator, 'triac_shorted', False) else 'Исправен'}\n"
        
        return state_info
    
    def get_quick_commands(self):
        return [
            ("", "📡", "Авто-отчет"),
            ("M0", "⚙️", "Режим нормальный"),
            ("M1", "🚀", "Режим разгон"),
            ("P2710", "1️⃣", "Мощность 10000"),
            ("N01", "🔌", "Запрос напряжения")
        ]