"""
Утилитарные функции для приложения
"""
from datetime import datetime

def get_timestamp(parent=None):
    """
    Получить форматированный timestamp с миллисекундами
    
    Args:
        parent: Родительское окно с control_panel (если доступно)
    
    Returns:
        str: Отформатированный timestamp в квадратных скобках или пустая строка
    """
    # По умолчанию показываем timestamp
    show_timestamp = True
    
    # Если передан parent с control_panel, берем настройку оттуда
    if parent and hasattr(parent, 'control_panel'):
        if hasattr(parent.control_panel, 'show_timestamp'):
            show_timestamp = parent.control_panel.show_timestamp
    # Или если напрямую передали control_panel
    elif hasattr(parent, 'show_timestamp'):
        show_timestamp = parent.show_timestamp
    
    if not show_timestamp:
        return ""
    
    now = datetime.now()
    timestamp = now.strftime("%H:%M:%S") + f".{now.microsecond // 1000:03d}"
    return f"[{timestamp}] "