#include "Stab_config.h"

// Инициализация кнопок
void InitButton() {
  #ifdef ENABLE_BUTTON
  btn.setDebTimeout(50);  // Устанавливаем время антидребезга
  btn.setHoldTimeout(1000);  // Устанавливаем время удержания для активации длительного нажатия
  btn.setStepTimeout(500);  // Устанавливаем время между шагами изменения мощности (500 мс)
  #endif
}
// Основной цикл обработки кнопок
void ButtonLoop() {
  #ifdef ENABLE_BUTTON
  btn.tick();  // Опрашиваем кнопку
  int delta;
  // Обработка короткого нажатия (+/- 10 Вт)
  if (btn.hasClicks(1)) {
    delta = modeUP ? 10 : -10;
    powerSetpoint += delta;
    powerSetpoint = constrain(powerSetpoint, 0, 10000);  // Ограничиваем мощность в пределах 0-10000 Вт
    updateOLEDDisplay_SetPoverPoint();
    #ifdef DEBUG
    Serial.print("1 Clicks, PowerSetpoint: ");
    Serial.println(powerSetpoint);
    #endif
    }
  // Обработка двойного клика (переключение режима UP/DW)
  if (btn.hasClicks(2)) {
    modeUP = !modeUP;  // Переключаем режим
    updateOLEDDisplay_ModeButton(modeUP);
    #ifdef DEBUG
    Serial.print("Mode changed to: ");
    Serial.println(modeUP ? "UP" : "DW");
    #endif
  }

  // Обработка тройного клика (включение/отключение режима "разгон")
  if (btn.hasClicks(3)) {
    boost(!boostMode);
    updateOLEDDisplay_BoostMode();
    #ifdef DEBUG
    Serial.print("Boost mode changed to: ");
    Serial.println(boostMode ? "ON" : "OFF");
    #endif
  }

  // Обработка импульсного удержания (шаги изменения мощности)
  if (btn.step()) {
    unsigned long currentTime = millis();
    unsigned long pressDuration = currentTime - pressStartTime;  // Продолжительность нажатия

    // Определяем шаг изменения мощности в зависимости от времени нажатия
    if (pressDuration < 10000) {  // Первые 10 секунд: 1 Вт/сек
      delta = modeUP ? 1 : -1;
    } else if (pressDuration < 20000) {  // 10-20 секунд: 10 Вт/сек
      delta = modeUP ? 10 : -10;
    } else {  // После 20 секунд: 100 Вт/сек
      delta = modeUP ? 100 : -100;
    }

    // Изменяем мощность с учетом шага
    setPower(powerSetpoint + delta);
    #ifdef DEBUG
    Serial.print("PowerSetpoint: ");
    Serial.println(powerSetpoint);
    #endif
  }

  // Запоминаем время начала нажатия при первом шаге
  if (btn.hold()) {
    pressStartTime = millis();  // Запоминаем время начала нажатия
  }
  #endif
}