// Библиотеки
 #include <Arduino.h>
 #include <ESP8266WiFi.h>
 #include <PZEM004Tv30.h>
 #include <SoftwareSerial.h>
 #include <PubSubClient.h>
 #include <EncButton.h>
 #include "ASOLED_ESP8266.h"
 #include "Stab_config.h"
 #include <ArduinoOTA.h> 
 #include <ESP8266mDNS.h>
 #include <WiFiUdp.h>
 #include <ESPAsyncWebServer.h>
 #include <EEPROM.h>
 #include "Stab_config.h"
 #include "web_pages.h"
// Переменные
 bool error = false;                          // Защита от пробития симистора
 float voltage = 0, current = 0,  energy= 0;  // Измеряемые значения
 uint16_t power = 0;                          // Мощность текущая 
 int16_t powerSetpoint = 0;                   // Задание мощности
 uint16_t maxPower = PMAX_TEN;                // максимально достигнутая
 volatile int16_t  PowerLevel = 0;            // Текущий уровень регулировки 0-1023*mult
 uint8_t mult = 10;
 volatile const int16_t  MaxPowerLevel = 1023*mult;// Максимальный уровень регулировки (не трогать)
 bool insufficientVoltage = false;            // Флаг недостаточного напряжения
 bool boostLoadActive = false;                // Флаг для блокировки регулировки на время прогрузки
 // PZEM
 bool PzemEnClear = false;                    // Флаг команды на обнуление счетчика
 EspSoftwareSerial::UART SSer; 
 PZEM004Tv30 pzem(SSer);
 // Для фильтра
 const int powerHistorySize = 10;                  // Количество измерений за 10 секунд 
 static float powerHistory[powerHistorySize];      // Массив для хранения значений мощности
 static int powerHistoryIndex = 0;                 // Индекс текущего значения в массиве
 static float averagePower = 0;                    // Среднее значение мощности за последние 10 секунд
 // Регулятор (triak.ino)
 unsigned long tm, tm2;                           // Переменные для задержек калибровки и разгона
 int8_t nPL=31;                                   // Калибровочный массив
 uint16_t PL[32] = {60, 182, 365, 585, 829, 1121, 1426, 1749, 2072, 2463, 2853, 3273, 3676, 4066, 4456, 4822, 5230, 5608, 5980, 6364, 6748, 7139, 7510, 7888, 8297, 8571, 8986, 9260, 9528, 9809, 10022, 10230};
 bool REG = true;                                  // Флаг работы регулятора
 byte stabilizeMode = STABILIZE_MODE;              // По умолчанию стабилизировать 0-мощность, 1-напряжение
 bool filterEnabled = PZEM_FILTR;                  // Фильтр значений мощности
 int16_t PowerLevel_ust;                           // Уставка для регулировки по напряжению
 volatile bool boostMode = false;                  // Флаг режима разгона
 bool heatEnabled = false;                         // Флаг включения нагрева
 bool TrueMAXPowerTEN=true;                        // Флаг действительности номинала ТЭНа
 unsigned long timeReg = DEFAULT_TIME_REG;         // Период регулирования 
 int K_upr = DEFAULT_K_UPR;                        // Коэффициент воздействия
 // Датчик пересечения с 0
 volatile unsigned long zeroCrossTime = 0;         // Время последнего срабатывания детектора нуля
 volatile unsigned long lastZeroCrossTime = 0;     // Время предыдущего пересечения с нулём
 const unsigned long debounceDelay = 80;           // Задержка для защиты от дребезга детектора нуля (мкс)
 volatile bool zeroCrossDetected = false;          // Флаг срабатывания детектора нуля
 // Переменные для управления семистором
 volatile long delayTime = 10000;                   // Задержка для открытия симистора (по умолчанию максимальная)
 long delayTimeDisplacement = DELAY_TIME_DISPLACEMENT; // Смещение, компенсирующее неточность датчика пересечения с 0
 volatile bool triacTriggered = false;             // Флаг для открытия симистора
 volatile unsigned long triacTurnOffTime = 0;      // Время выключения симистора
 bool interrTriacFlag=true;                        // Флаг триггера назначения прерывания задержки открытия симистора при включении нагрева
 unsigned long delayLow = DEFAULT_DELAY_LOW;       // Нижний предел задержки открытия симистора (0)
 unsigned long delayHigh = DEFAULT_DELAY_HIGH;     // Верхний предел задержки открытия симистора (9500)
 // Переменные для кнопки (button.ino)
 #ifdef ENABLE_BUTTON
 Button btn(BUTTON_PIN);             // Указываем пин кнопки
 bool modeUP = true;                 // Режим изменения мощности (UP/DW)
 unsigned long pressStartTime = 0;   // Время начала нажатия
 #endif

 // Параметры MQTT
 byte mqtt_attempts = MQTT_ATTEMPTS; // Количество попыток подключения при инициализации
 bool mqtt_reconnection = MQTT_RECONNECTION; // Пытаться ли переподключаться при потере соединения
 unsigned long mqtt_time_publication = MQTT_TIME_PUBLICATION; // Период публикаций 
 String mqtt_server = MQTT_SERVER;
 uint mqtt_port = MQTT_PORT;
 String mqtt_user = MQTT_USER;
 String mqtt_password = MQTT_PASSWORD;
 String mqtt_topic_power = MQTT_TOPIC_POWER; // Топик для установки мощности
 String mqtt_topic_boost = MQTT_TOPIC_BOOST; // Топик для включения/выключения режима разгона
 String mqtt_topic_heat = MQTT_TOPIC_HEAT;   // Топик для включения/выключения нагрева
 String mqtt_topic_status = MQTT_TOPIC_STATUS;   // Топик для публикации статуса

 int16_t UDP_Port = 12345; // Порт UDP рассылки

 // USART с Самоваром
 String pendingResponse = "";              // Ответ, который нужно отправить

 // Прогрузка ТЭНа в web_server.ino
 int16_t powerSetpointT;                   // Запомнить на время прогрузки ТЭНа
 bool heatEnabledBoost;                    // Флаг на время прогрузки ТЭНа запомнить состояние нагрева
 int16_t PowerLevelT;                      // Запомнить на время разгона
 // WiFi
 String savedSSID, savedPass;
 bool hotspotMode = false;
 int8_t RSSI = 0;
 String localIP = "";
 WiFiClient espClient;                 // Объект WiFi
 PubSubClient mqttClient(espClient);   // Объект MQTT
 AsyncWebServer server(80);            // Объект вэбсервера
// Функции
void boost(bool SW);
// Запуск...
void setup() {
  initOLED();                   // Инициализация дисплея
  InitButton();                 // Инициализация кнопок
  Serial.begin(9600);
  PZEMInit();                   // Инициализация измерений
  Serial.println("\nStart...");
                                // Инициализация пинов 
   pinMode(boostPin, OUTPUT);  digitalWrite(boostPin, LOW);
   pinMode(heatPin, OUTPUT);   digitalWrite(heatPin, LOW);
   initWiFi();                  // Загрузка сохраненных данных и  запуск Wi-Fi
   setupWebServer();            // Запуск веб-сервера
   initOTA();                   // Запуск ОТА
   setupMQTT();                 // запуск MQTT
   StaticOLEDDisplay();         // Выводим на дисплей статические названия полей
   zeroCrossInit();             // Инициализация датчика пересечения с 0
   for (uint8_t i=0; i<32; i++) Serial.print(String(PL[i]) + ", "); Serial.println();
}
//Основной цикл
void loop() { 
    
  MDNS.update(); ArduinoOTA.handle(); // Обработка ОТА
  USART_GetRequests();                // Принимаем по UART запросы от Самовара
  USART_SendReport();                 // Отправляем ответ Самовару по UART
  loopMQTT();                         // Обработка MQTT
  ButtonLoop();                       // Обработка кнопки


  static unsigned long timeout = millis(); //остальное раз в секунду
  if (millis() >= timeout) {    
    timeout = millis() + 1000;             // перезапуск секундного таймера 
    PZEMLoop();                            // Читаем параметры электросети
    #ifdef ENABLE_UDP_BROADCAST
    broadcastStatus();
    #endif    
    #ifdef ENABLE_WEB_SERVER
     //установка флага невозможности выполнить задачу по мощности
     insufficientVoltage = (powerSetpoint > power && PowerLevel == MaxPowerLevel);
    #endif // ENABLE_WEB_SERVER
    Check_Triak(); // Проверка симистора на пробитие
    triakLoop();                           // Обработка симистора
    updateOLEDDisplay();                   // Выводим инфу на дисплей
    static unsigned long timeout2 = millis(); // раз в 20 секунд
    if (millis() >= timeout2) { 
      timeout2 = millis() + 20000; 
      loopWIFI();                            // проверка работы WiFi и реконнект
    }    
  }    
}