// #define ZCDEBUG
#include "Stab_config.h"
#ifdef ZCDEBUG
int zeroCrossPerSecond = 0;
volatile int zeroCrossCount = 0;
volatile int lastZeroCrossCount = 0;
Ticker timer;
#endif

void heat(bool SW) { // Переключатель нагрева
 if (error && SW) return; // Не даём включить при ошибке ТЭНа
 heatEnabled = SW;
 digitalWrite(heatPin, SW ? HIGH : LOW);
 if (!heatEnabled && boostMode) boost(OFF);
 if (!heatEnabled) { 
  PowerLevel=0; 
  powerSetpoint=0;
 }
}
void boost(bool SW) { // Переключатель разгона
  if (error && SW) return;
	boostMode = SW;
    if (boostMode) {
      TrueMAXPowerTEN=false; //Старт прогрузки
      //maxPower = 1;
      tm2 = millis() + 6000;
      PowerLevelT = PowerLevel;
      PowerLevel = MaxPowerLevel;
      heat(ON);
    } else {
      PowerLevel = PowerLevelT;
      digitalWrite(boostPin, LOW);     
    }
}
uint16_t calc_proportion(const uint16_t multiplier1, const uint16_t multiplier2, const uint32_t divider) {//Функция пропорционального пересчета параметра
  uint32_t p;
  p = (1+(2 * (uint32_t)multiplier1 * (uint32_t)multiplier2)/divider)/2;
  if (p > 0xFFFF) {	  p = 0xFFFF;  }
  return (uint16_t)p;
} 
void setPower(int16_t newPower) {
        newPower = constrain(newPower, 0, 10000);  // Ограничиваем мощность в пределах 0-10000 Вт
        if (boostMode) boost(OFF); // Если был разгон отключаем
        powerSetpoint = newPower;
        heat(newPower != 0); // Включаем нагрев если уставка мощности больше 0, иначе выключаем 
        if (stabilizeMode==1) { // Если стабилизация по напряжению
          if (powerSetpoint < maxPower) PowerLevel_ust = calc_proportion(powerSetpoint, MaxPowerLevel, maxPower);
          else PowerLevel_ust = MaxPowerLevel; // Останемся в пределах диапазона
          for (int i = 0; i < powerHistorySize; i++) {powerHistory[i]=powerSetpoint;}
        }  
}
void initModeFromEEPROM() {// Инициализация режима из EEPROM
  EEPROM.begin(EEPROM_SIZE);
    if (EEPROM.read(MODE_SAVED_FLAG_ADDR) == MODE_SAVED_FLAG_VALUE) {
    EEPROM.get(TIME_REG_ADDR, timeReg);//free
    EEPROM.get(K_UPR_ADDR, K_upr);
    EEPROM.get(DELAY_LOW_ADDR, delayLow);
    EEPROM.get(DELAY_HIGH_ADDR, delayHigh);
    EEPROM.get(PMAX_TEN_ADDR, maxPower);
    stabilizeMode = EEPROM.read(STABILIZE_MODE_ADDR);
    filterEnabled = EEPROM.read(FILTER_ENABLED_ADDR) == 1;
    EEPROM.get(DELAY_TIME_DISPLACEMENT_ADDR, delayTimeDisplacement);
    EEPROM.get(PL_ADDR, PL);    
    EEPROM.get(UDP_PORT_ADDR, UDP_Port);
    // Проверяем допустимые пределы:
    if (maxPower < 1 || maxPower > 10000) maxPower = PMAX_TEN;//
    if (timeReg < 1 || timeReg > 8) timeReg = DEFAULT_TIME_REG;//
    if (K_upr < 1 || K_upr > 10) K_upr = DEFAULT_K_UPR;
    if (delayLow < 0 || delayLow > 1500) delayLow = DEFAULT_DELAY_LOW;
    if (delayHigh < 7000 || delayHigh > 13000) delayHigh = DEFAULT_DELAY_HIGH;
    if (delayTimeDisplacement < -1500 || delayTimeDisplacement > 1500) delayTimeDisplacement = DELAY_TIME_DISPLACEMENT;
  }
  EEPROM.end();
}
void calculateDelayTime() {
    // Нормализованное значение мощности (0..1)
    float powerRatio = (float)PowerLevel / MaxPowerLevel;
    // Общая площадь под полуволной синусоиды
    const float totalArea = 6366.1977f; // 20000 / π
    float dD=delayHigh-delayLow;
    // Вычисляем площадь для текущего уровня мощности
    float area = powerRatio * totalArea;
    // Решаем уравнение для нахождения t
    float t = (10000.0f / PI) * acos(1.0f - (PI * area) / 10000.0f);
    // Преобразуем t в задержку (микросекунды)
    // Задержка должна изменяться от большего к меньшему
    delayTime = 10000 - (unsigned long)t;
    // Ограничиваем задержку в пределах delayLow и delayHigh
    delayTime = constrain(delayTime, delayLow, delayHigh);
    // Корректируем крайние значения
    if (PowerLevel == 0) delayTime = delayHigh; // Максимальная задержка
    if (PowerLevel == MaxPowerLevel) delayTime = delayLow; // Минимальная задержка
    delayTime += delayTimeDisplacement; // учитываем смещение
    #ifdef REGDEBUG
    Serial.println("delayTime:" + String(delayTime));
    #endif
}

// Глобальные переменные для управления временем и состоянием
static unsigned long lastPowerLevelChange = 0;  // Время последнего изменения PowerLevel
static float filteredPower = 0;                // Фильтрованное значение мощности

float Filtr(float newVal) {// Адаптивный фильтр бегущего среднего
    static float filVal = 0;
    float k;
      // Резкость фильтра зависит от отклонения
    if (abs(newVal - filVal) > maxPower/10) k = 0.9;  // Быстрая реакция на большие изменения
    else k = 0.2;                             // Плавная коррекция малых отклонений
    filVal += (newVal - filVal) * k;
    return filVal;
}
void updateAveragePower() {// Функция для обновления среднего значения мощности
    powerHistory[powerHistoryIndex] = power; // Добавляем текущее значение мощности
    powerHistoryIndex = (powerHistoryIndex + 1) % powerHistorySize; // Обновляем индекс
    float sum = 0;// Вычисляем среднее значение мощности
    for (int i = 0; i < powerHistorySize; i++) {
        sum += powerHistory[i];
    }
    averagePower = sum / powerHistorySize;
    power = round(averagePower);
}
uint16_t PowerToPL(uint16_t Power) {// Перевод значения из мощности в уровень   
 uint16_t P = (Power * MaxPowerLevel) / maxPower;
    if (P >= PL[31]) return MaxPowerLevel;
    else if (P <= PL[0]) return 0;
    else {
      for (uint8_t i = 0; i < 31; i++) {
        if (P <= PL[i+1] && P > PL[i]) {
          //Serial.println("1 = " + String((i+1)*32*mult) + ", 2 = " + String(round(32*mult*(P-PL[i])/(PL[i+1]-PL[i]))));
          return constrain((i+1)*32*mult + round(32*mult*(P-PL[i])/(PL[i+1]-PL[i])), 0, MaxPowerLevel);
        }
      }
    }
    return 0;
} 
static unsigned long timeJump;
void Check_Triak() { // Проверка на пробитие симистора
  if (heatEnabled && !boostMode && !boostLoadActive && stabilizeMode==0) {
    if (millis()>= timeJump && ((power - powerSetpoint) >= maxPower * K_CHECK)) {
      heat(OFF);
      error = true;
      Serial.println("Ошибка более "+ String(K_CHECK*100) +"% установки мощности за " + String(TIME_CHECK_TRIAK) + " млсек, возможно пробит симистр!");
      LD.printString_6x8("=== Triak error! ===", 1, 7);
    }
  }
}
void updatePowerLevel() { // Регулятор
  static int16_t lastPowerSetpoint = 0;
  if (boostLoadActive) {// Обновляем таблицу мощностей ТЭН-а в процессе его прогрузки
    if (millis() >= (tm+6000)) { //через 6 сек запись в калибровочную таблицу
      if (!heatEnabled) { boostLoadActive = false; return; }//если вдруг нагрев отключен калибровку отменяем
      if (maxPower < power) maxPower = power; 
      PL[nPL]=power;
      Serial.println("Power level= " + String(PowerLevel) + ", Power = " + String(PL[nPL]));
      PowerLevel = PowerLevel - 32*mult;
      if (PowerLevel<=0 || PowerLevel>MaxPowerLevel) PowerLevel = 0;
      nPL--;
      tm = millis();
      if (nPL<=-1) {
        EndCalibrateTEN();
      }
    }
  }     
  else if (REG) { // если регулятор включен// Блокируем изменение PowerLevel, если активна прогрузка ТЭНа
    if (stabilizeMode==0) { // Если стабилизация по мощности  
      if (!boostMode && heatEnabled) { // если не разгон и включен нагрев
        if (powerSetpoint != lastPowerSetpoint) {// Если задание изменилось - выполнить грубую коррекцию
          if (maxPower == 0) {maxPower = 1; PowerLevel = MaxPowerLevel; TrueMAXPowerTEN = false; boostLoadActive = true; return;} // Не знаем мощность ТЭНа - прогружаем его
          timeJump = millis() + TIME_CHECK_TRIAK;
                // Расчет начального PowerLevel для приближения к powerSetpoint
          PowerLevel = PowerToPL(powerSetpoint);
          //Serial.println("Power =>> "+ String(powerSetpoint) + ", Level =>> " + String(PowerLevel));
                // Сброс таймеров
          lastPowerLevelChange = millis()+1000;//после прыжка ждем на секунду больше
          lastPowerSetpoint = powerSetpoint;
          return;
        }
        // Обновление фильтра каждую секунду
        if (filterEnabled) power = (int) Filtr((float) power); 
        // Если с последнего изменения прошло меньше timeReg сек - не корректировать
        if (millis() - lastPowerLevelChange < timeReg*1000) return;

        // Логика коррекции
        if (abs(power - powerSetpoint) > (maxPower * 0.005)) {// 0,5% от номинала
            float ratio = (float)powerSetpoint / maxPower;// Агрессивная коррекция при большом отклонении
            PowerLevel = constrain(PowerLevel+(((powerSetpoint-power)*MaxPowerLevel*K_upr)/maxPower)/10, 0, MaxPowerLevel);
            lastPowerLevelChange = millis();
        } else {// Плавная коррекция ±1 (0.1%)
            if (power < powerSetpoint + 0.001 * maxPower) PowerLevel += 1;//0.2 % зона нечуствительности для снижения болтанки
            else if (power > powerSetpoint - 0.001 * maxPower) PowerLevel -= 1;
            PowerLevel = constrain(PowerLevel, 0, MaxPowerLevel);
            lastPowerLevelChange = millis();
        }
      }
      if (heatEnabled) { 
        if (boostMode) {// В режиме разгона полностью открываем симистор
          PowerLevel = MaxPowerLevel;
          if (tm2!=0 && millis() >= tm2) {//через 6 сек после включения разгона сохраняем максимальную мощность ТЭН-а и включаем разгонный ТЭН
            maxPower = power;
            digitalWrite(boostPin, HIGH);
            tm2 = 0;
          }
        }
      } else {           // А если нагрев вдруг отключен закрываем  
        PowerLevel = 0;
      }
    } else { // Если стабилизация по напряжению
      PowerLevel = calc_proportion(PowerLevel_ust, 230*230, (uint32_t) voltage*voltage);
      if (PowerLevel > MaxPowerLevel) PowerLevel = MaxPowerLevel; 
      updateAveragePower();//фильтр измерений мощности
    }// -стабилизация по мощности/напряжению
  } else { //REG// Если регулятор выведен просто меняем его установку от 0 до 1023
    PowerLevel = constrain(powerSetpoint, 0, MaxPowerLevel); 
  }
}

void StartCalibrateTEN() {// Начинаем прогрузку ТЭНа
  #ifdef ENABLE_WEB_SERVER
  boostLoadActive = true;  // Активируем режим прогрузки
  powerSetpointT = powerSetpoint;
  heatEnabledBoost = heatEnabled;
  heatEnabled = true;  // Включаем нагрев
  digitalWrite(heatPin, HIGH);  // Включаем ТЭН
  PowerLevelT = PowerLevel;
  PowerLevel = MaxPowerLevel;  // Устанавливаем начальную мощность
  TrueMAXPowerTEN=false; //Старт прогрузки
  maxPower = 1;
  tm=millis();
  nPL=31;
  #endif // ENABLE_WEB_SERVER
}
void EndCalibrateTEN() {
    Serial.println("Exit calibrate TEN.");
    TrueMAXPowerTEN = true;
    boostLoadActive = false;
    for (uint8_t i=0; i<32; i++) {//Пересчет в относительные единицы чтобы отвязаться от мощности ТЭНа
      PL[i] = (uint16_t)round((PL[i]*MaxPowerLevel)/maxPower);
      Serial.print(String(PL[i]) + ", ");
    }
    Serial.println();
    EEPROM.begin(EEPROM_SIZE);
    EEPROM.put(PL_ADDR, PL);
    EEPROM.put(PMAX_TEN_ADDR, maxPower);
    EEPROM.commit();
    EEPROM.end();
    heatEnabled = heatEnabledBoost;  // Восстанавливаем предыдущий режим нагрева
    digitalWrite(heatPin, heatEnabled ? HIGH : LOW);
    PowerLevel = PowerLevelT;  // Возвращаем PowerLevel в исходное состояние
    powerSetpoint = powerSetpointT;

}
void IRAM_ATTR zeroCrossISR() {// Обработчик прерывания по детектору нуля
    unsigned long currentTime = micros();
  if (currentTime - lastZeroCrossTime > debounceDelay) {
  zeroCrossDetected = true;
  zeroCrossTime = currentTime;
  lastZeroCrossTime = currentTime;
  #ifdef ZCDEBUG
  zeroCrossCount++;
  #endif
  }
}
void IRAM_ATTR timer1ISR() {// Обработчик прерывания по таймеру для открытия семистора
   if (zeroCrossDetected && !triacTriggered) {
      unsigned long currentTime = micros();
      if (currentTime - zeroCrossTime >= delayTime) {
        digitalWrite(triacPin, HIGH);  // Включаем симистор
        triacTriggered = true;
        triacTurnOffTime = currentTime + 100;  // Устанавливаем время выключения
        zeroCrossDetected = false; //Закомментировать чтоб видеть на осциллографе длину открытых полупериодов
      }
    }
    // Выключаем симистор через 100 микросекунд
    if (triacTriggered && micros() >= triacTurnOffTime) {
      digitalWrite(triacPin, LOW);
      triacTriggered = false;
    }
}
#ifdef ZCDEBUG
void onTimer() { // Вычисляем количество переходов через ноль в 10 секунд
  zeroCrossPerSecond = zeroCrossCount - lastZeroCrossCount;
  lastZeroCrossCount = zeroCrossCount;
  // Выводим в Serial
  Serial.println("Z cr/10s:" + String(zeroCrossPerSecond));
}
#endif
void zeroCrossInit() {
   pinMode(zeroCrossPin, INPUT);
   pinMode(triacPin, OUTPUT);
   digitalWrite(triacPin, LOW);

   initModeFromEEPROM();
   attachInterrupt(digitalPinToInterrupt(zeroCrossPin), zeroCrossISR, FALLING ); // Настройка прерывания по детектору нуля
   interrTriacFlag = heatEnabled;
   timer1_attachInterrupt(timer1ISR);  // Настройка таймера для проверки задержки
   timer1_write(500);  // Прерывание каждые 0.1 мс (50000 тактов при 5 МГц)
   #ifdef ZCDEBUG
   Serial.println("Каждых 10 сек подсчет пересечений с нулем, должно быть около 1000");
   timer.attach(10.0, onTimer); // Период 10 секунд вызов подсчета пересечений с 0
   #endif
   Serial.println("Работа..."); Serial.println();
}

void triakLoop(){ //Раз в период регулирования
 updatePowerLevel(); //Пересчитываем уровень регулирования
                                                //если нагрев отключен прерывания отключаем
 if (heatEnabled && interrTriacFlag) {timer1_enable(TIM_DIV16, TIM_EDGE, TIM_LOOP);  interrTriacFlag=false;}// Таймер с частотой 5 МГц (80 МГц / 16)
 if (!heatEnabled && !interrTriacFlag) {timer1_disable(); interrTriacFlag=true; digitalWrite(triacPin, LOW);}//*/
 calculateDelayTime(); // Пересчитываем актуальную задержку открытия семистора раз в секунду
}