#pragma once
#ifndef __SAMOVAR_I_H_
#define __SAMOVAR_I_H_
#include <Arduino.h>
//**************************************************************************************************************
// Параметры
//**************************************************************************************************************
#define SAMOVAR_HOST "samovarich"
//**************************************************************************************************************
#define defaultSSID  "" // Ваша точка доступа №1
#define defaultPass  "" // Пароль от неё
#define WiFiAP_Pass  "12345678" //Можно поменять пароль точки доступа

//**************************************************************************************************************
// Выбор используемой платы ESP32 - вполне нормально автоматически определяет
//**************************************************************************************************************
//#define BOARD DEVKIT
#define BOARD ESP32S3
//**************************************************************************************************************
bool Setup_Key = 4; //ключ актуальности настроек для первичной загрузки (0-255), можно поменять для переинициализации

//**************************************************************************************************************
// Настройки использования подсистем Самовара
//**************************************************************************************************************
  
#define PRESSURE_1WIRE {0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x55}  //датчик давления по 1Wire
// адреса датчиков температур по умолчанию (сейчас здесь адреса Измерителя)
  const uint8_t STEAM_ADRESS[8] = {0x28, 0x10, 0x55, 0x44, 0x33, 0x22, 0x01, 0xd8};
  const uint8_t PIPE_ADRESS[8]  = {0x28, 0x10, 0x55, 0x44, 0x33, 0x22, 0x02, 0xd7};
  const uint8_t WATER_ADRESS[8] = {0x28, 0x10, 0x55, 0x44, 0x33, 0x22, 0x04, 0xc9};
  const uint8_t TANK_ADRESS[8]  = {0x28, 0x10, 0x55, 0x44, 0x33, 0x22, 0x03, 0xd2};
  const uint8_t ACP_ADRESS[8]   = {0x28, 0x10, 0x55, 0x44, 0x33, 0x22, 0x05, 0xcc};

#define STEPPER_STEPS 400 //количество шагов, 200 x MS
#define STEPPER_STEP_ML 1020 //количество шагов на 1 мл жидкости для драйвера с шагами 1/2
#define STEPPER_MAX_SPEED 8000

#define WHLS_ALARM_TIME 3 //Секунд, через сколько сработает тревога по уровню флегмы

#define WF_ALARM_COUNT 20 //Секунд до отключения нагрева, если в течении этого времени не будет подана вода охлаждения

//Максимальный угол сервопривода
#define SERVO_ANGLE 180
// Количество емкостей. (0 используется всегда). Для расчета позиции серво считаем угол поворота между емкостями
// равным 180 / CAPACITY_NUM
#define CAPACITY_NUM 10
#define MAX_PRG 29 //Максимум строк в программе 0-29

//#define USE_STEPPER_ACCELERATION              //использовать плавный старт и торможение шагового двигателя
#endif