Протокол передачи информационных и управляющих данных между стабилизатором мощности/напряжения/тока и управляющим устройством
-----------------------------------------------------------------------------------------------------------------------------
##### Стабилизатор без дополнительного запроса с интервалом порядка секунды передает управляющему устройству информационную посылку символами в ASCII коде. В интервале между информационными посылками стабилизатор принимает от управляющего устройства управляющую посылку символами в ASCII коде.

---  

[Параметры порта](Protocol.md#%D0%BF%D0%B0%D1%80%D0%B0%D0%BC%D0%B5%D1%82%D1%80%D1%8B-%D0%BF%D0%BE%D1%80%D1%82%D0%B0)  

[Информация от стабилизатора](Protocol.md#%D0%B8%D0%BD%D1%84%D0%BE%D1%80%D0%BC%D0%B0%D1%86%D0%B8%D1%8F-%D0%BE%D1%82-%D1%81%D1%82%D0%B0%D0%B1%D0%B8%D0%BB%D0%B8%D0%B7%D0%B0%D1%82%D0%BE%D1%80%D0%B0)  
- [Формат посылки:](Protocol.md#%D1%84%D0%BE%D1%80%D0%BC%D0%B0%D1%82-%D0%BF%D0%BE%D1%81%D1%8B%D0%BB%D0%BA%D0%B8)  
- [Служебный байт «Состав данных»](Protocol.md#%D1%81%D0%BB%D1%83%D0%B6%D0%B5%D0%B1%D0%BD%D1%8B%D0%B9-%D0%B1%D0%B0%D0%B9%D1%82-%D1%81%D0%BE%D1%81%D1%82%D0%B0%D0%B2-%D0%B4%D0%B0%D0%BD%D0%BD%D1%8B%D1%85)  
- [Служебный байт «Режим + ошибки»](Protocol.md#%D1%81%D0%BB%D1%83%D0%B6%D0%B5%D0%B1%D0%BD%D1%8B%D0%B9-%D0%B1%D0%B0%D0%B9%D1%82-%D1%80%D0%B5%D0%B6%D0%B8%D0%BC--%D0%BE%D1%88%D0%B8%D0%B1%D0%BA%D0%B8)  
- [Формат передачи параметров](Protocol.md#%D1%84%D0%BE%D1%80%D0%BC%D0%B0%D1%82-%D0%BF%D0%B5%D1%80%D0%B5%D0%B4%D0%B0%D1%87%D0%B8-%D0%BF%D0%B0%D1%80%D0%B0%D0%BC%D0%B5%D1%82%D1%80%D0%BE%D0%B2)  

[Управление стабилизатором](Protocol.md#%D1%83%D0%BF%D1%80%D0%B0%D0%B2%D0%BB%D0%B5%D0%BD%D0%B8%D0%B5-%D1%81%D1%82%D0%B0%D0%B1%D0%B8%D0%BB%D0%B8%D0%B7%D0%B0%D1%82%D0%BE%D1%80%D0%BE%D0%BC)  
- [Формат посылки для установки режима](Protocol.md#%D1%84%D0%BE%D1%80%D0%BC%D0%B0%D1%82-%D0%BF%D0%BE%D1%81%D1%8B%D0%BB%D0%BA%D0%B8-%D0%B4%D0%BB%D1%8F-%D1%83%D1%81%D1%82%D0%B0%D0%BD%D0%BE%D0%B2%D0%BA%D0%B8-%D1%80%D0%B5%D0%B6%D0%B8%D0%BC%D0%B0)
- [Формат посылки для выбора передаваемого дополнительного параметра](Protocol.md#%D1%84%D0%BE%D1%80%D0%BC%D0%B0%D1%82-%D0%BF%D0%BE%D1%81%D1%8B%D0%BB%D0%BA%D0%B8-%D0%B4%D0%BB%D1%8F-%D0%B2%D1%8B%D0%B1%D0%BE%D1%80%D0%B0-%D0%BF%D0%B5%D1%80%D0%B5%D0%B4%D0%B0%D0%B2%D0%B0%D0%B5%D0%BC%D0%BE%D0%B3%D0%BE-%D0%B4%D0%BE%D0%BF%D0%BE%D0%BB%D0%BD%D0%B8%D1%82%D0%B5%D0%BB%D1%8C%D0%BD%D0%BE%D0%B3%D0%BE-%D0%BF%D0%B0%D1%80%D0%B0%D0%BC%D0%B5%D1%82%D1%80%D0%B0)
- [Формат посылки для передачи уставки](Protocol.md#%D1%84%D0%BE%D1%80%D0%BC%D0%B0%D1%82-%D0%BF%D0%BE%D1%81%D1%8B%D0%BB%D0%BA%D0%B8-%D0%B4%D0%BB%D1%8F-%D0%BF%D0%B5%D1%80%D0%B5%D0%B4%D0%B0%D1%87%D0%B8-%D1%83%D1%81%D1%82%D0%B0%D0%B2%D0%BA%D0%B8)  
  
---

### Параметры порта:
**9600N1**, т.е.
- _скорость 9600,_
- _четность не проверяется,_
- _один стоп-бит._

---

### Информация от стабилизатора
#### Формат посылки:

**TAABBCCCCDDDD\<CR\>**, где
- _**T** - заголовок `(буква «T» 0х54)`_
- _**AA** - служебный байт «состав данных»_
- _**BB** - служебный байт «режим + ошибки»_
- _**CCCC** - основной параметр `(два байта, передаются в виде шестнадцатиричного числа 0х0000..0хFFFF, диапазон значений 0...65535)`_
- _**DDDD** - дополнительный параметр `(два байта, передаются в виде шестнадцатиричного числа 0х0000..0хFFFF, диапазон значений 0...65535)`_
- _**\<CR\>** - признак конца посылки `(символ "возврат каретки" 0хOD)`_

###### _Пример 1. Возможная посылка от [Стабилизированного регулятора на базе Arduino...][стаб_1]:_
>**T050003EA03E8\<CR\>**, где
>- _**05** - «состав данных» `(основной - напряжение в нагрузке, доп. - уставка напряжения)`_
>- _**00** - «режим + ошибки» `(режим рабочий, ошибок нет)`_
>- _**03EA** - основной параметр `(напряжение в нагрузке - 100,2В)`_
>- _**03E8** - доп.параметр `(уставка - 100,0В)`_

###### _Пример 2. Возможная посылка от [Простого стабилизатора мощности ТЭНа...][стаб_2]:_
>**T170804E208D5\<CR\>**, где
>- _**17** - «состав данных» `(основной - мощность в нагрузке, доп. - напряжение сети)`_
>- _**08** - «режим + ошибки» `(режим рабочий, напряжения сети недостаточно для достижения уставки)`_
>- _**04E2** - основной параметр `(мощность в нагрузке - 1250Вт)`_
>- _**08D5** - доп.параметр `(напряжение сети - 226,1В)`_

#### Служебный байт «Состав данных»:
  _Байт «состав данных» формируется побитово, в зависимости от типов передаваемых параметров, передаётся в виде шестнадцатиричного числа._  
  _Исходим из того, что стабилизатор удерживает уставку на выходе с достаточной точностью, потому основной параметр может быть измеренный, уставка, рассчитанный и пр._  
  _Единственное требование - **основной параметр должен максимально точно отражать состояние нагрузки.**_  
  _Основной параметр для конкретного стабилизатора не меняется и передается в каждой посылке._  
  _Дополнительный параметр - может изменяться от посылки к посылке с соответствующим изменением байта «состав данных»._

b*000000***хх** - младшие два бита описывают основной параметр
- _00 - запрещённое значение_
- _01 - напряжение на нагрузке_
- _10 - ток в нагрузке_
- _11 - мощность в нагрузке_

b**xxхххх***00* - старшие шесть бит описывают дополнительный параметр
- _000000 - нет параметра_
- _000001 - напряжение на нагрузке `(если основной - напряжение, то напряжение уставки)`_
- _000010 - ток в нагрузке `(если основной - ток, то ток уставки)`_
- _000011 - мощность в нагрузке `(если основной - мощность, то мощность уставки)`_
- _000100 - нет параметра_
- _000101 - напряжение сети_
- _000110 - сопротивление нагрузки_
- _000111 - номинальная мощность нагрузки_
- _прочие - ..._

###### _Пример 3. Байт «состав данных» для [Стабилизированного регулятора на базе Arduino...][стаб_1]_
>**0х05**, т.е (b**00000101**), где
>- _b000001**01** - основной параметр - напряжение в нагрузке_
>- _b**000001**01 - дополнительный параметр - напряжение уставки_

###### _Пример 4. Байт «состав данных» для [Простого стабилизатора мощности ТЭНа...][стаб_2]:_
>**0х17**, т.е (b**00010111**), где
>- _b000101**11** - основной параметр - мощность в нагрузке_
>- _b**000101**11 - дополнительный параметр - напряжение сети_

#### Служебный байт «Режим + ошибки»:
  _Байт «режим + ошибки» формируется побитово, в зависимости от состояния стабилизатора, передаётся в виде шестнадцатиричного числа._

b*000000***хх** - младшие два бита описывают режим
- _00 - рабочий режим `(стабилизатор старается поддерживать заданный выходной параметр)`_
- _01 - разгон_
- _10 - нагрузка отключена_
- _11 - аварийное отключение нагрузки `(удаленное включение невозможно)`_

b**xxхххх***00* - старшие шесть бит описывают ошибки
- _000000 - ошибок нет_
- _000001 - отсутствие сетевого напряжения, нагрузка отключена_
- _000010 - напряжения сети недостаточно для достижения уставки_
- _прочие - ..._

###### _Пример 5. Байт «режим + ошибки» в рабочем режиме и в отсутствие ошибок:_
>**0х00**, т.е (b**00000000**), где
>- _b000000**00** - режим рабочий_
>- _b**000000**00 - ошибок нет_

###### _Пример 6. Байт «режим + ошибки» в рабочем режиме при недостаточном напряжении сети:_
>**0х08**, т.е (b**00001000**), где
>- _b000010**00** - режим рабочий_
>- _b**000010**00 - напряжения сети недостаточно для достижения уставки_

###### _Пример 7. Байт «режим + ошибки» в отсутствие сети:_
>**0х06**, т.е (b**00000110**), где
>- _b000001**10** - нагрузка отключена_
>- _b**000001**10 - отсутствие сетевого напряжения, нагрузка отключена_

#### Формат передачи параметров:
  _Значения параметров передаются в виде двухбайтного шестнадцатиричного числа в ASCII-коде_

- _**Мощность - в Ваттах.** Например: 1250Вт -> 0x04E2 -> **04E2**_
- _**Напряжение - в Вольтах, умноженных на 10.** Например: 226,1В -> 2261 -> 0x08D5 -> **08D5**_
- _**Ток - в Амперах, умноженных на 100.** Например: 15,22А -> 1522 -> 0x05F2 -> **05F2**_
- _**Сопротивление - в Омах, умноженных на 100.** Например: 15,11Ом -> 1511 -> 0x05E7 -> **05E7**_
  
---

### Управление стабилизатором
#### Формат посылки для установки режима:
**MA\<CR\>**, где
- _**M** - Заголовок `(буква «M» 0х4D или «m» 0х6D)`_
- _**A** - код режима `(идентичен коду режима в байте «режим + ошибки»)`_
    - _0 - перейти в рабочий режим `(стабилизатор старается поддерживать заданный выходной параметр)`_
    - _1 - перейти в режим «разгон»_
    - _2 - отключить нагрузку_
- _**\<CR\>** - признак конца посылки `(символ "возврат каретки" 0хOD)`_

Т.е.  
**M0\<CR\>** - перейти в рабочий режим.  
**M1\<CR\>** - разгон.  
**M2\<CR\>** - стоп.  

#### Формат посылки для выбора передаваемого дополнительного параметра:
 _В случае невозможности передачи запрошенного доп.параметра, а также для кода параметра в запросе равном "00",_ 
 _стабилизатор передает доп.параметр по умолчанию, с соответствующим указанием кода параметра в байте "Состав данных"._
 
**NAA\<CR\>**, где
- _**N** - Заголовок `(буква «N» 0х4E или «n» 0х6E)`_
- _**AA** - код параметра `(идентичен коду доп.параметра в байте «состав данных»)`_
    - _h00 - доп.параметр по умолчанию для конкретного стабилизатора_
    - _h01 - напряжение на нагрузке `(если основной - напряжение, то напряжение уставки)`_
    - _h02 - ток в нагрузке `(если основной - ток, то ток уставки)`_
    - _h03 - мощность в нагрузке `(если основной - мощность, то мощность уставки)`_
    - _h04 - доп.параметр по умолчанию для конкретного стабилизатора_
    - _h05 - напряжение сети_
    - _h06 - сопротивление нагрузки_
    - _h07 - номинальная мощность нагрузки_
- _**\<CR\>** - признак конца посылки `(символ "возврат каретки" 0хOD)`_

#### Формат посылки для передачи уставки:
  _Тип параметра уставки соответствует основному параметру, передаваемому стабилизатором в информационной посылке._  
  _Проверка параметра на выход за пределы диапазона проводится стабилизатором._

**ABBBB\<CR\>**, где
- _**A** - Заголовок `(буква в зависимости от типа основного параметра: «P» 0х50 или «p» 0х70 - мощность, «U» 0х55 или «u» 0х75 - напряжение, «I» 0х49 или «i» 0х69 - ток)`_
- _**BBBB** - уставка `(два байта, передаются в виде шестнадцатиричного числа в формате передачи параметров)`_
- _**\<CR\>** - признак конца посылки `(символ "возврат каретки" 0хOD)`_

Т.е.  
**P04E2\<CR\>** - установить мощность 1250Вт  
**U03E8\<CR\>** - установить напряжение 100,0В  
**I05F2\<CR\>** - установить ток 15,22А  

[стаб_1]: https://alcodistillers.ru/forum/viewtopic.php?id=1524 "Стабилизированный регулятор на базе Arduino с управлением через UART"
[стаб_2]: https://alcodistillers.ru/forum/viewtopic.php?id=1549 "Простой стабилизатор мощности ТЭНа из китайских модулей"
