<p align="center">
  <a href="https://webserial.pro?ref=ghfeature" target="_blank">
    <img src="/docs/feature.png" width="1200">
  </a>
</p>

<br/>

<p>
  <img src="https://img.shields.io/github/last-commit/ayushsharma82/WebSerial.svg?style=for-the-badge" />
  &nbsp;
  <img src="https://img.shields.io/github/actions/workflow/status/ayushsharma82/WebSerial/ci.yml?branch=master&style=for-the-badge" />
  &nbsp;
  <img src="https://img.shields.io/github/license/ayushsharma82/WebSerial.svg?style=for-the-badge" />
</p>

<br/>

**WebSerial** is a remote terminal to log, monitor or debug your firmware without being connected by wire. It lives on your wireless microcontroller itself and can be accessed anytime through your browser.

<br/>
<br/>

## Features

- 📜 Log, monitor or debug your firmware/product with ease
- 🔥 A powerful tool that lives in your microcontroller itself
- 🛜 Access it anytime & from anywhere within same network (LAN)
- 🎷 No need to learn HTML/CSS/JS
- 🛫 Ready to use within 4-5 lines of code

<br/>

## Supported MCUs

WebSerial works on the following microcontrollers/boards:

- ESP8266
- ESP32
- RP2040+W (Example: Raspberry Pico W)
- RP2350+W (Example: Raspberry Pico 2W)
- *( more coming soon )*

<br/>

## Documentation

Learn more about Installation & Usage: [Click Here](https://docs.webserial.pro?ref=gitreadme)

<br>

## OSS Preview

Once you have integrated WebSerial library in your code, a terminal like below will be accessible over your WiFi microcontroller's IP:

<p align="center"><img src="/docs/preview.png" width="1200"></p>

<br/>
<br/>

## Looking for more? Upgrade to Pro.

WebSerial Pro comes with the following extended functionality:

- Export logs into TXT, JSON or CSV file
- Lock scroll feature
- Timestamps
- Enable/Disable Command Input Bar
- Customizable font & terminal font size from UI itself
- Branding (Add your own Logo)
- Commercial License

<br> <b>Available here: </b>

- [Official Website ( webserial.pro )](https://webserial.pro?ref=ghrepo)

<br/>

<a href="https://webserial.pro?ref=ghpropreview" target="_blank">
  <img src="/docs/pro-preview.png" alt="WebSerial Pro" width="1200">
</a>

<br>

## Contributions

Every contribution to this repository is highly appreciated! If you spot any bug or problem, open a issue or pull request so that it can be rectified for everyone.

**For feature requests:** Please open a issue and I'll add the feature in a future release once I get some time in my hands.

<br/>

## License

WebSerial open-source edition is licensed under Affero General Public License v3.0 ( AGPL-3.0 ).

If you are intending to use WebSerial in a commercial project, please consider purchasing [WebSerial Pro](https://webserial.pro?ref=ghlicense) which comes with a less restrictive SOFTT Commercial License 1.2 ( SCL-1.2 ).
