#include "Stab_config.h"

// Определяем макрос для включения SoftwareSerial поддержки
#define PZEM004_SOFTSERIAL
#include <PZEM004Tv30.h>
#include <SoftwareSerial.h>

// Создаем SoftwareSerial и PZEM объекты
SoftwareSerial pzemSWSerial(PZEM_RX_PIN, PZEM_TX_PIN);
PZEM004Tv30 pzem(pzemSWSerial, PZEM_DEFAULT_ADDR);

void ReadPZEM() { 
    //Serial.println(".");
    float newVoltage = pzem.voltage();
    float newCurrent = pzem.current();
    #ifdef EMULATE
    float newPower = powerSetpoint + random(0, 20) ;
    #else
    float newPower = pzem.power();
    #endif
    float newEnergy = pzem.energy();

    if (!isnan(newVoltage)) voltage = newVoltage;
    if (!isnan(newCurrent)) current = newCurrent;
    if (!isnan(newEnergy))  energy = newEnergy;
        // Если с последней установки мощности прошло меньше 2 сек - не учитывать
    if ((millis() - timeJump) < 2000) return;
    if (!isnan(newPower))   power = round(newPower);
} 

void PZEMInit() { 
    // Инициализация SoftwareSerial
    pzemSWSerial.begin(9600);
    
    Serial.println("PZEM004T initialized with SoftwareSerial");
    Serial.println("RX: " + String(PZEM_RX_PIN) + ", TX: " + String(PZEM_TX_PIN));
    
    // Тестовое чтение для проверки связи
    delay(100);
    float testVoltage = pzem.voltage();
    if (!isnan(testVoltage)) {
        Serial.println("PZEM004T connection OK");
    } else {
        Serial.println("PZEM004T connection FAILED");
    }
}

void PZEMLoop() {
    if (PzemEnClear) {
        pzem.resetEnergy();
        PzemEnClear = false; 
        Serial.println("PZEM energy counter reset");
    }
    ReadPZEM();
}