// Основные настройки проекта для ESP32-C3
#define ENABLE_OLED_DISPLAY    // Раскомментируйте для использования дисплея
#define ENABLE_BUTTON          // Раскомментируйте для использования кнопки
#define ENABLE_OTA             // OTA-обновление
#define ENABLE_WIFI            // Работа с WiFi
#define ENABLE_WEB_SERVER      // Веб-сервер
#define ENABLE_UDP_BROADCAST   // UDP рассылка статуса для управления по WIFI
#define ENABLE_USART_SAMOVAR   // Управление по USART
#define PMAX_TEN 2027          // Номинальная мощность ТЭНа по умолчанию
#define DEFAULT_TIME_REG 4     // Период регулирования по умолчанию (1-8 с)
#define DEFAULT_K_UPR 50       // Коэффициент воздействия по умолчанию (1-100)
#define DEFAULT_DELAY_LOW 500    // Нижний предел задержки (мкс) для фазового регулирования
#define DEFAULT_DELAY_HIGH 9500  // Верхний предел задержки (мкс)
#define TIME_CHECK_TRIAK 30000  // Время млсек, через которое будет переход в режим ошибки если мощность выше уставки на Рмакс * K_CHECK
#define K_CHECK 0.2             // доля максимальной мощности ТЭНа, при превышении отклонения от задания на неё сработает защита от пробития симистора
//#define REGDEBUG              // включение отладки
//#define EMULATE               // эмуляция PZEM для отладки Самоварыча


// Настройки по умолчанию для WiFi
#define defaultSSID "" // Ссид и пароль по умолчанию, позволяет использовать два набора, первый можно сохранить в NVS 
#define defaultPass "" // через WEB интерфейс, это второй по ходу загрузки
#define WIFI_RECONNECT // Переподключаться при потере связи

#define UDP_BROADCAST_INTERVAL 1000 // миллисекунд, период отправки UDP пакетов

// Константы для пинов ESP32-C3 Super Mini
#define boostPin 1            // Реле разгона
#define heatPin 0             // Реле ТЭНов
#define zeroCrossPin 10        // Детектор нуля
#define triacPin 5            // Симистор или твердотельное реле
#define BUTTON_PIN 6          // Кнопка 
#define BUTTON2_PIN 7          // Кнопка 2
#define PZEM_RX_PIN 3          // RX, пины для software serial PZEM-004T
#define PZEM_TX_PIN 4          // TX 
//20 и 21 - TX0/RX0 для связи с Самоваром, 8 и 9 I2C. Свободные пины: 

// Пространства имен для NVS
#define NVS_WIFI_NAMESPACE "wifi"
#define NVS_MODE_NAMESPACE "mode"

#if defined(ENABLE_UDP_BROADCAST)
#define ENABLE_WEB_SERVER 
#endif
#if defined(ENABLE_WEB_SERVER) || defined(ENABLE_OTA)
#define ENABLE_WIFI 
#endif

#define ON true
#define OFF false
