 // Переменные для кнопки
 #ifdef ENABLE_BUTTON
 Button btn(BUTTON_PIN, INPUT, HIGH);            // Кнопка увеличения
 Button btn2(BUTTON2_PIN, INPUT, HIGH);          // Кнопка уменьшения
 MultiButton btn3;                  // Мультинажатие
 unsigned long pressStartTime = 0;  // Время начала нажатия
 #endif
// Инициализация кнопок
void InitButton() {
  #ifdef ENABLE_BUTTON
  
  btn.setDebTimeout(25);      // время антидребезга
  btn.setHoldTimeout(1000);   // время удержания для активации длительного нажатия
  btn.setStepTimeout(500);    // время между шагами изменения мощности (500 мс)
  
  btn2.setDebTimeout(25);     // время антидребезга для второй кнопки
  btn2.setHoldTimeout(1000);  // время удержания для второй кнопки
  btn2.setStepTimeout(500);   // время между шагами изменения мощности (500 мс)

  btn3.setHoldTimeout(3000);  // время удержания для двух кнопок одновременно
  #endif
}

// Основной цикл обработки кнопок
void ButtonLoop() {
  #ifdef ENABLE_BUTTON
  //btn.tick();   // Опрашиваем первую кнопку
  //btn2.tick();  // Опрашиваем вторую кнопку
  btn3.tick(btn, btn2);  // Опрашиваем нажатие обеих кнопок
  
    // Включение/отключение режима "разгон"
  if (btn3.hold()) {
    boost(!boostMode);
    #ifdef DEBUG
    Serial.print("Boost mode changed to: ");
    Serial.println(boostMode ? "ON" : "OFF");
    #endif
  }

  // Обработка короткого нажатия кнопки 1 (+10 Вт)
  if (btn.hasClicks(1)) {
    setPower(powerSetpoint + 10);
    updateOLEDDisplay_SetPoverPoint();
    #ifdef DEBUG
    Serial.print("Button1 click, PowerSetpoint: ");
    Serial.println(powerSetpoint);
    #endif
  }

  // Обработка короткого нажатия кнопки 2 (-10 Вт)
  if (btn2.hasClicks(1)) {
    setPower(powerSetpoint - 10);
    updateOLEDDisplay_SetPoverPoint();
    #ifdef DEBUG
    Serial.print("Button2 click, PowerSetpoint: ");
    Serial.println(powerSetpoint);
    #endif
  }

  // Обработка импульсного удержания кнопки 1 (увеличение мощности)
  if (btn.step()) {
    processPowerStep(true); // true - увеличение
    updateOLEDDisplay();  
  }

  // Обработка импульсного удержания кнопки 2 (уменьшение мощности)
  if (btn2.step()) {
    processPowerStep(false); // false - уменьшение
    updateOLEDDisplay();  
  }

  // Запоминаем время начала нажатия при первом шаге
  if (btn.hold() || btn2.hold()) {
    pressStartTime = millis();
  }
  #endif
}

// Функция обработки шагового изменения мощности
void processPowerStep(bool increase) {
  unsigned long currentTime = millis();
  unsigned long pressDuration = currentTime - pressStartTime;
  int delta;

  // Определяем шаг изменения мощности в зависимости от времени нажатия
  if (pressDuration < 10000) {    // Первые 10 секунд: 1 Вт/сек
    delta = increase ? 1 : -1;
  } else if (pressDuration < 20000) { // 10-20 секунд: 10 Вт/сек
    delta = increase ? 10 : -10;
  } else {                        // После 20 секунд: 100 Вт/сек
    delta = increase ? 100 : -100;
  }

  // Изменяем мощность с учетом шага
  setPower(powerSetpoint + delta);
  
  #ifdef DEBUG
  Serial.print("Power step: ");
  Serial.print(increase ? "+" : "-");
  Serial.print(delta);
  Serial.print("W, PowerSetpoint: ");
  Serial.println(powerSetpoint);
  #endif
}