//#define ZCDEBUG



 void IRAM_ATTR R_zeroCrossISR();

uint16_t PowerToDelay(uint16_t Power) {// Перевод значения из мощности в задержку
    uint16_t P = (Power * 10000) / maxPower; // 0-10000    
    // PL[0] - макс. мощность (мин. задержка), PL[31] - мин. мощность
    if (P >= PL[0]) return delayLow; // >= макс. мощности
    if (P <= PL[31]) return delayHigh; // <= мин. мощности    
    for (uint8_t i = 0; i < 31; i++) {
        if (P <= PL[i] && P > PL[i+1]) { // Обратный порядок!
            float fraction = (float)(PL[i] - P) / (PL[i] - PL[i+1]);
            uint16_t delay = delayLow + (i * TimeStep) + round(TimeStep * fraction);
            return constrain(delay, delayLow, delayHigh);
        }
    }
    return delayHigh;
}
void calculateSensitivityTable() {// Рассчет таблицы чувствительности реакции в зависимости от относительной мощности
  float step = ((delayHigh - delayLow) / 31);
  for (uint8_t i = 0; i < 31; i++) {
      uint16_t delay_i = delayLow + i * step;
      uint16_t delay_i1 = delayLow + (i+1) * step;      
      if (PL[i] != PL[i+1]) sensitivity_table[i] = (float)(delay_i1 - delay_i) / (PL[i+1] - PL[i]);
        else sensitivity_table[i] = (float)(delayHigh - delayLow) / 10000.0;
  }
}
void heat(bool SW) { // Переключатель нагрева
 if (error && SW) return; // Не даём включить при ошибке ТЭНа
 heatEnabled = SW;
 if (!heatEnabled && boostMode) boost(OFF); //отключаем разгон если отключили нагрев
 if (!heatEnabled) { 
  delayTime = delayHigh; 
  powerSetpoint = 0;
 }
}
void boost(bool SW) { // Переключатель разгона
 static uint16_t powerSPtemp=0; 
 static int16_t delayTimeT;
  if (error && SW) return;
	boostMode = SW;
    updateOLEDDisplay_BoostMode();
    if (boostMode) {
      powerSPtemp = powerSetpoint;
      TrueMAXPowerTEN=false; //Старт прогрузки
      //maxPower = 1;
      tm2 = millis(); //Время на прогрузку для определения мощности ТЭНа
      delayTimeT = delayTime; // Запомнили задержку
      delayTime = delayLow; // ТЭН на полную
      heat(ON); // Включили нагрев, контактор включим в регуляторе через tm2 мс
    } else {
      powerSetpoint = powerSPtemp;//При отключении разгона восстанавливаем исходное задание мощности
      delayTime = delayTimeT; // и задержку
      digitalWrite(boostPin, LOW);  // Отключили контактор
    }
}
void setPower(int16_t newPower) {
  newPower = constrain(newPower, 0, 10000);  // Ограничиваем мощность в пределах 0-10000 Вт
  if (boostMode) boost(OFF); // Если был разгон отключаем
  heat(newPower != 0); // Включаем нагрев если уставка мощности больше 0, иначе выключаем 
  if (REG) { // если регулятор включен// Блокируем изменение delayTime, если активна прогрузка ТЭНа
    if (heatEnabled) { // если включен нагрев
      if (powerSetpoint != newPower) {// Если задание изменилось 
        powerSetpoint = newPower;
        power = newPower;
        delayTime = PowerToDelay(powerSetpoint);// Расчет начального delayTime для приближения к powerSetpoint
        //Serial.println("Power =>> "+ String(powerSetpoint) + ", Delay =>> " + String(delayTime));
        lastDelayChange = millis()+1000;//после прыжка ждем на секунду больше
        timeJump = millis();//задержка начала проверки симистора на пробитие
      }
    }
  }
}
void updateDelay() { // Регулятор
  if (!boostMode && heatEnabled) { // если не разгон и включен нагрев
    // Если с последней коррекции прошло меньше timeReg сек - попуск 
    if (millis() - lastDelayChange < timeReg*1000) return;

    // Адаптивная коррекция
    if (abs(power - powerSetpoint) > (maxPower * 0.002)) {// Если отклонение от задания больше 0.2% (на ТЭН 2 кВт это 4 Вт)
      uint16_t P_current = (powerSetpoint * 10000) / maxPower; //Перевод в относительные еденицы
      for (uint8_t i = 0; i < 31; i++) { // Ищем индекс в таблице
        if (P_current >= PL[i+1] && P_current <= PL[i]) {//нашли
          float error_percent = (float)(powerSetpoint - power) * 100.0 / maxPower; //процент ошибки
          int16_t correction = (int16_t)(error_percent * sensitivity_table[i] * (K_upr * 1.6));  // умножение на чувствительность и на силу воздействия
          correction = constrain(correction, -500, 500);// но не более 500 мкс чтоб не вылететь за края???
          delayTime = constrain(delayTime + correction, delayLow, delayHigh); //подравняем по краям
          lastDelayChange = millis();
          //Serial.println("Адаптивная:"+String(correction));
          return;
        }
      }
    } else {// При меньшем отклонении плавная коррекция ±1 мкс
      int16_t dTinc = 0;
      if (power < powerSetpoint + 0.0005 * maxPower) dTinc = -1;//0.05 % зона нечуствительности для снижения болтанки (на ТЭН 2 кВт это +-1Вт)
      else if (power > powerSetpoint - 0.0005 * maxPower) dTinc = 1;
      delayTime = constrain(delayTime + dTinc, delayLow, delayHigh);
      lastDelayChange = millis();
      //if (abs(dTinc) > 0) Serial.println("Плавная:"+String(dTinc));
      return;
    }
  } 
  if (boostMode) {// В режиме разгона полностью открываем симистор
    delayTime = delayLow;
    powerSetpoint = power;
    if (tm2!=0 && (millis() - tm2 >= 6000)) {//через 6 сек после включения разгона сохраняем максимальную мощность ТЭН-а и включаем разгонный ТЭН
      if (power > 10) maxPower = power;
      digitalWrite(boostPin, HIGH);
      tm2 = 0;
    }
  }
}
void initModeFromNVS() {// Функция для загрузки всех настроек режима из NVS
  timeReg = readNVSUint(NVS_MODE_NAMESPACE, "time_reg", DEFAULT_TIME_REG);
  K_upr = readNVSUint(NVS_MODE_NAMESPACE, "k_upr", DEFAULT_K_UPR);
  delayLow = readNVSUint(NVS_MODE_NAMESPACE, "delay_low", DEFAULT_DELAY_LOW);
  delayHigh = readNVSUint(NVS_MODE_NAMESPACE, "delay_high", DEFAULT_DELAY_HIGH);
  maxPower = readNVSUint(NVS_MODE_NAMESPACE, "max_pow", PMAX_TEN);
  UDP_Port = readNVSUint(NVS_MODE_NAMESPACE, "UDP_port", 12345);
  // Загрузка калибровочной таблицы
  preferences.begin(NVS_MODE_NAMESPACE, true);
  size_t bytesRead = preferences.getBytes("pl_table", PL, sizeof(PL));
  preferences.end();
  
  // Если таблица не была сохранена, инициализируем значениями по умолчанию
  if (bytesRead != sizeof(PL)) {
    Serial.println("PL не найдена в NVS, используем стандартную.");
  }

  // Проверка допустимых пределов
  if (maxPower < 1 || maxPower > 10000) maxPower = PMAX_TEN;
  if (timeReg < 1 || timeReg > 8) timeReg = DEFAULT_TIME_REG;
  if (K_upr < 1 || K_upr > 100) K_upr = DEFAULT_K_UPR;
  if (delayLow < 0 || delayLow > 1500) delayLow = DEFAULT_DELAY_LOW;
  if (delayHigh < 7000 || delayHigh > 13000) delayHigh = DEFAULT_DELAY_HIGH;
  TimeStep = round((delayHigh - delayLow) / 31);
  Serial.println("Mode settings loaded from NVS");
}
void saveModeToNVS() {// Функция для сохранения всех настроек режима в NVS
  writeNVSUint(NVS_MODE_NAMESPACE, "time_reg", timeReg);
  writeNVSUint(NVS_MODE_NAMESPACE, "k_upr", K_upr);
  writeNVSUint(NVS_MODE_NAMESPACE, "delay_low", delayLow);
  writeNVSUint(NVS_MODE_NAMESPACE, "delay_high", delayHigh);
  writeNVSUint(NVS_MODE_NAMESPACE, "max_pow", maxPower);
  writeNVSUint(NVS_MODE_NAMESPACE, "UDP_port", UDP_Port);
  // Сохранение калибровочной таблицы
  preferences.begin(NVS_MODE_NAMESPACE, false);
  preferences.putBytes("pl_table", PL, sizeof(PL));
  preferences.end();
  
}
void Check_Triak() { // Проверка на пробитие симистора
  if (heatEnabled && !boostMode && !boostLoadActive) {
    if ((millis() - timeJump >= TIME_CHECK_TRIAK) && ((power - powerSetpoint) >= maxPower * K_CHECK) && maxPower > 100) {
      heat(OFF);
      digitalWrite(heatPin, LOW);//отключаем контактор
      error = true;
      Serial.println("Ошибка более "+ String(maxPower * K_CHECK) +" мощности за " + String(TIME_CHECK_TRIAK/1000) + " сек, возможно пробит симистр!");
      LD.printString_6x8("=== Triak error! ===", 1, 7);
    }
  }
}
void CalibrateLoop() {
  if (millis() - tm >= 6000) { //через 6 сек запись в калибровочную таблицу
  tm = millis();
  if (!heatEnabled) { boostLoadActive = false; return; }//если вдруг нагрев отключен калибровку отменяем
  if (maxPower < power && power > 10) maxPower = power; 
  PLt[nPL]=power;
  Serial.println("delayTime= " + String(delayTime) + ", Power = " + String(PLt[nPL]));
  delayTime = delayTime - round((delayHigh - delayLow) / 31);
  nPL--;
  if (nPL<0) {
    EndCalibrateTEN();
    }
  } 
}
void StartCalibrateTEN() {// Начинаем прогрузку ТЭНа
  boostLoadActive = true;  // Активируем режим прогрузки
  digitalWrite(heatPin, HIGH);
  heatEnabled = true;  // Включаем нагрев
  delayTime = delayHigh;  // Устанавливаем начальную мощность
  TrueMAXPowerTEN=false; //Старт прогрузки
  maxPower = 1;
  tm = millis();
  nPL=31;
}
void EndCalibrateTEN() {
    Serial.println("Exit calibrate TEN.");
    TrueMAXPowerTEN = true;
    boostLoadActive = false;
    for (uint8_t i=0; i<32; i++) {//Пересчет в относительные единицы чтобы отвязаться от мощности ТЭНа
      PL[i] = (uint16_t)round((PLt[i]*10000)/maxPower);
      Serial.print(String(PL[i]) + ", ");
    }
    Serial.println();
    saveModeToNVS();
    calculateSensitivityTable();
    heatEnabled = false;  // Отключаем нагрев
    digitalWrite(heatPin, LOW);
}
// Обработчик прерывания таймера
bool IRAM_ATTR timerISR(gptimer_handle_t timer, const gptimer_alarm_event_data_t *edata, void *user_ctx) {
    static bool triac_state = false;
    if (heatEnabled && !triac_state) {
        delayTrue= micros() - zeroCrossTime;
        digitalWrite(triacPin, HIGH);  // Включаем симистор
        uint64_t counter;
        gptimer_get_raw_count(timer, &counter);
        gptimer_alarm_config_t alarm_config;
        alarm_config.alarm_count = counter + 100; // 100 мкс
        alarm_config.reload_count = 0;
        alarm_config.flags.auto_reload_on_alarm = false;
        gptimer_set_alarm_action(gptimer, &alarm_config);
        //timerAlarm(timer2, 5, true, 0);
        triac_state = true;
    } else {
        // Выключаем симистор
        digitalWrite(triacPin, LOW);
        triac_state = false;
        timer_armed = false;
        gptimer_stop(gptimer);
    }
    
    return true;
}
void timerInit() { // Инициализация таймера
    gptimer_config_t timer_config = {
        .clk_src = GPTIMER_CLK_SRC_DEFAULT,
        .direction = GPTIMER_COUNT_UP,
        .resolution_hz = 1000000, // 1 MHz, 1 микросекунда на тик
    };
    gptimer_new_timer(&timer_config, &gptimer);
    gptimer_event_callbacks_t cbs = {
        .on_alarm = timerISR,
    };
    gptimer_set_raw_count(gptimer, 0);
    gptimer_register_event_callbacks(gptimer, &cbs, NULL);
    gptimer_enable(gptimer);
}
void IRAM_ATTR F_zeroCrossISR() {// Обработчик прерывания по детектору нуля
  ZeroCrossTime_F = micros();
  lastZeroCrossTime = zeroCrossTime;
  zeroCrossTime = ZeroCrossTime_F + dtTime;  
  if (zeroCrossTime-lastZeroCrossTime > 5000) {//антидребезг
        if (!heatEnabled || delayTime == 0) return;
    uint64_t counter;
    gptimer_get_raw_count(gptimer, &counter);
    uint64_t alarm_time = counter + delayTime + dtTime - 12;//текущее время + задержка + смещение датчика нуля -12 мкс - усреднённая задержка операций активации таймера
    if (!timer_armed) {
        gptimer_alarm_config_t alarm_config;
        alarm_config.alarm_count = alarm_time;
        alarm_config.reload_count = 0;
        alarm_config.flags.auto_reload_on_alarm = false;
        gptimer_set_alarm_action(gptimer, &alarm_config);
        gptimer_start(gptimer);
        timer_armed = true;
    }
    if (StartZC) attachInterrupt(digitalPinToInterrupt(zeroCrossPin), R_zeroCrossISR, RISING ); // Настройка прерывания по детектору нуля
  }
}
void IRAM_ATTR R_zeroCrossISR() {// Обработчик прерывания по детектору нуля для определения смещения
  static uint32_t ZeroCrossTime_R = 0, lastZeroCrossTime_R = 0;
  static uint8_t ZCSCount = 100;
  lastZeroCrossTime_R = ZeroCrossTime_R;
  ZeroCrossTime_R = micros();
  if (ZeroCrossTime_R-lastZeroCrossTime_R < 50) return;//антидребезг
  if (ZCSCount) {
    dtTime = (dtTime + ((ZeroCrossTime_R - ZeroCrossTime_F) >> 1)) >> 1;
    ZCSCount--;
  } else StartZC= false;
  attachInterrupt(digitalPinToInterrupt(zeroCrossPin), F_zeroCrossISR, FALLING ); // Настройка прерывания по детектору нуля  
}
void zeroCrossInit() {
  calculateSensitivityTable();
  attachInterrupt(digitalPinToInterrupt(zeroCrossPin), F_zeroCrossISR, FALLING ); // Настройка прерывания по детектору нуля
  timerInit(); // Инициализируем таймер
  Serial.println("Работа..."); Serial.println();
}
void triakLoop() {
  if (boostLoadActive) {
    CalibrateLoop();// Обновляем таблицу мощностей ТЭН-а в процессе его прогрузки
    return;
  }
  else if (REG) updateDelay();
  static bool lastHeatState = false;
  if (heatEnabled != lastHeatState) {
      if (!heatEnabled) {
          digitalWrite(triacPin, LOW);
      }
      lastHeatState = heatEnabled;
  }
  
  Check_Triak();                          // Проверка симистора на пробитие
  //установка флага невозможности выполнить задачу по мощности
  insufficientVoltage = (powerSetpoint > power && delayTime == delayLow);
  #ifdef ZCDEBUG
  //if (heatEnabled)    Serial.println("Задержка: " + String(delayTime) + " - " + String(delayTrue)+ " мкс, Смещение нуля: " + String(dtTime));
  #endif
}