// web_pages.h
#pragma once
#include <Arduino.h>

// Главная страница
const char MAIN_PAGE[] PROGMEM = R"=====(
<!doctype html>
<html>
<head>
<meta charset=utf-8>
<meta name=viewport content="width=device-width,initial-scale=1">
<title>Стабилизатор</title>
<style>
body{font-family:Arial,sans-serif;background:#121212;color:#eee;margin:0;padding:10px}
.c{max-width:800px;margin:0 auto}h1,h2{text-align:center}
.d{background:#1e1e1e;border-radius:10px;padding:15px;margin:10px 0}
.g{display:grid;grid-template-columns:1fr 1fr;gap:10px}
.v{font-size:1.2em;color:#4CAF50}.a{color:#ff5555}.n{margin:20px 0}
.b{background:#4CAF50;border:0;padding:8px 15px;border-radius:5px;cursor:pointer;min-width:120px;color:#fff;text-decoration:none}
.b:hover{background:#45a049}
.no-data{color:#ff5555}
@media (max-width:600px){.c{max-width:100%;padding:0 10px}}
</style>
<link rel="icon" href="https://www.samovar-tool.ru/doc/device/img/drex_tehn_custom.png" type="image/png">
<script>
let lastUpdateTime = 0;
let regulatorMode = true; // true - мощность, false - задержка
let lastMDT = 50, lastmDT = 10; // значения по умолчанию

function updateDataStatus() {
const now = Date.now();
const elements = document.querySelectorAll('.v');
elements.forEach(el => {
if (now - lastUpdateTime > 10000) {
el.innerText = "???";
el.classList.add('no-data');
} else {
el.classList.remove('no-data');
}
});
}

let powerUpdateTimeout;
function updatePower(value) {
let url;
if (regulatorMode) {
url = '/set_power?power=' + encodeURIComponent(value);
} else {
url = '/set_delay?delay=' + encodeURIComponent(value);
}
document.getElementById('powerInput').value = value;
document.getElementById('powerRange').value = value;
clearTimeout(powerUpdateTimeout);
powerUpdateTimeout = setTimeout(() => {
fetch(url, {method: 'GET'})
.then(response => {
if (!response.ok) {
console.error('Ошибка при установке');}
return response.text();})
.then(data => {
console.log('Установлено: ' + value + (regulatorMode ? ' Вт' : ' мкс'));})
.catch(error => {console.error('Ошибка сети:', error);});}, 100);
}

function toggleBoost() {
const boostValue = document.getElementById('boost').checked ? '1' : '0';
fetch('/set_boost?boost=' + boostValue, {method: 'GET'});
}

function toggleHeat() {
const heatValue = document.getElementById('heat').checked ? '1' : '0';
fetch('/set_heat?heat=' + heatValue, {method: 'GET'});
}

function toggleRegulator() {
const regulatorValue = document.getElementById('regulator').checked ? '1' : '0';
fetch('/set_regulator?regulator=' + regulatorValue, {method: 'GET'});
regulatorMode = document.getElementById('regulator').checked;
updateUImode();
}

function updateUImode() {
const powerBlock = document.getElementById('powerBlock');
const powerLabel = document.getElementById('powerLabel');
const powerInput = document.getElementById('powerInput');
const powerRange = document.getElementById('powerRange');
const maxPowerValue = document.getElementById('maxPowerValue');
const minPowerValue = document.getElementById('minPowerValue');

if (regulatorMode) {
powerLabel.innerText = 'Установка мощности (Вт):';
powerInput.min = 0;
powerInput.max = document.getElementById('maxPower').innerText.replace(' Вт', '');
powerRange.min = 0;
powerRange.max = document.getElementById('maxPower').innerText.replace(' Вт', '');
powerRange.style.transform = 'scaleX(1)';
powerRange.style.direction = 'ltr';
minPowerValue.innerText = '0';
maxPowerValue.innerText = document.getElementById('maxPower').innerText;
} else {
powerLabel.innerText = 'Установка задержки (мкс):';
const mDT = parseInt(lastmDT);
const MDT = parseInt(lastMDT);
powerInput.min = mDT;
powerInput.max = MDT;
powerRange.min = mDT;
powerRange.max = MDT;
powerRange.style.transform = 'scaleX(-1)';
powerRange.style.direction = 'rtl';
minPowerValue.innerText = mDT;
maxPowerValue.innerText = MDT;
}
}

function updateData() {
fetch('/get_data')
.then(response => {
if (!response.ok) throw new Error('Network error');
return response.json();
})
.then(data => {
lastUpdateTime = Date.now();
const prevRegulatorMode = regulatorMode;
regulatorMode = document.getElementById('regulator').checked;

lastMDT = data.MDT;
lastmDT = data.mDT;

document.getElementById('regulator').checked = data.R;
document.getElementById('voltage').innerText = data.V + " В";
document.getElementById('current').innerText = data.C.toFixed(2) + " A";
document.getElementById('power').innerText = data.P + " Вт";
document.getElementById('powerSetpoint').innerText = data.PSP + " Вт";
document.getElementById('maxPower').innerText = data.MP + " Вт";
document.getElementById('delayTime').innerText = data.DT + " (из "+ data.mDT + "-" + data.MDT + ")";
document.getElementById('energy').innerText = data.E.toFixed(3) + " кВт·ч";
document.getElementById('boost').checked = data.BM;
document.getElementById('heat').checked = data.HE;
document.getElementById('insufficientVoltage').style.display = data.IV ? 'block' : 'none';
document.getElementById('alarm').innerText = data.ER;
if (data.ER) {document.getElementById('alarm').style.color = 'red';}

if (prevRegulatorMode != regulatorMode) {
updateUImode();
}

if (!regulatorMode) {
const powerInput = document.getElementById('powerInput');
const powerRange = document.getElementById('powerRange');
if (powerInput.value != data.DT) {
powerRange.value = data.DT;
}
const maxPowerValue = document.getElementById('maxPowerValue');
const minPowerValue = document.getElementById('minPowerValue');
if (minPowerValue) {
minPowerValue.innerText = data.mDT;
maxPowerValue.innerText = data.MDT;
}
} else {
document.getElementById('maxPowerValue').innerText = data.MP + " Вт";
document.getElementById('powerRange').max = data.MP;
}
});
}

setInterval(updateDataStatus, 1000);
setInterval(updateData, 2000);
updateData();
</script>
</head>
<body>
<div class=c>
<h1>Стабилизатор мощности</h1>
<div class=d>
<label><input type='checkbox' id='regulator' onchange='toggleRegulator()'> Регулятор.</label><label id="alarm"></label>
<p>Напряжение: <span id="voltage" class=v>---</span>, Ток: <span id="current" class=v>---</span></p>
<p>Мощность: <span id="power" class=v>---</span>. Целевая: <span id="powerSetpoint" class=v>---</span></p>
<p>MAX: <span id="maxPower" class=v>---</span></p>
<p>Задержка открытия симистора: <span id="delayTime" class=v>---</span></p>
<p>Счетчик: <span id="energy" class=v>---</span></p>
<div id="powerBlock">
<span id="powerLabel">Установка мощности (Вт):</span>
<input type="number" id="powerInput" name="power" min="0" max="10000" onchange="updatePower(this.value)"><br>
<span id="minPowerValue">0</span> <input type="range" id="powerRange" min="0" max="10000" oninput="updatePower(this.value)"> <span id="maxPowerValue" class=v>---</span><br><br>
</div>
<label>Режим разгона: <input type='checkbox' id='boost' onchange='toggleBoost()'></label><br><br>
<label>Включить нагрев: <input type='checkbox' id='heat' onchange='toggleHeat()'></label><br><br>
<a href='/setup_wifi' class='b'>Настройки</a> <br>
<p id="insufficientVoltage" style="color:red; display:none;">Недостаточное напряжение.</p>
</div>
</body>
</html>
)=====";

// -----------------------------------------------------------------------------------------------------------------Страница настроек
const char SETTINGS_PAGE[] PROGMEM = R"=====(
<!doctype html>
<html>
<head>
<meta charset=utf-8>
<meta name=viewport content="width=device-width,initial-scale=1">
<title>Настройки</title>
<style>
body{font-family:Arial,sans-serif;background:#121212;color:#eee;margin:0;padding:10px}
.c{max-width:800px;margin:0 auto}
h1,h2{text-align:center;color:#4CAF50}
.d{background:#1e1e1e;border-radius:10px;padding:15px;margin:10px 0}
.g{display:grid;grid-template-columns:1fr 1fr;gap:10px}
.v{font-size:1.2em;color:#4CAF50}.a{color:#ff5555}.n{margin:20px 0}
.b{background:#4CAF50;border:0;padding:8px 15px;border-radius:5px;cursor:pointer;min-width:120px;color:#fff;text-decoration:none}
.b:hover{background:#45a049}
.no-data{color:#ff5555}
label{display:flex;align-items:center;gap:10px;margin-bottom:5px}
input[type="checkbox"], input[type="radio"] {width:auto;margin:0}
input:not([type="checkbox"]):not([type="radio"]), select{width:100%;padding:10px;box-sizing:border-box;background:#333;color:#eee;border:1px solid #444;border-radius:5px;font-size:16px}
.tab{overflow:hidden;border:1px solid #444;background-color:#1e1e1e;border-radius:5px 5px 0 0}
.tab button{background-color:inherit;float:left;border:none;outline:none;cursor:pointer;padding:14px 16px;transition:0.3s;color:#eee}
.tab button:hover{background-color:#333}
.tab button.active{background-color:#4CAF50}
.tabcontent{display:none;padding:15px;border:1px solid #444;border-top:none;background:#1e1e1e;border-radius:0 0 5px 5px}
.separator{border-top:1px solid #444;margin:20px 0}
@media (max-width:600px){.c{padding:0 10px}}
</style>
<script>
function openTab(evt, tabName) {
var i, tabcontent, tablinks;
tabcontent = document.getElementsByClassName("tabcontent");
for (i = 0; i < tabcontent.length; i++) {
tabcontent[i].style.display = "none";
}
tablinks = document.getElementsByClassName("tablinks");
for (i = 0; i < tablinks.length; i++) {
tablinks[i].className = tablinks[i].className.replace(" active", "");
}
document.getElementById(tabName).style.display = "block";
evt.currentTarget.className += " active";
}
function restartDevice() {
if (confirm("Вы уверены, что хотите перезагрузить устройство?")) {
fetch('/restart', { method: 'GET' });
}
}
window.onload = function() {
document.getElementById('Other').style.display = "block";
};
</script>
</head>
<body>
<div class=c>
<h1>Настройки</h1>
<div class=d>
<div class=tab>
<button class="tablinks" onclick="openTab(event, 'WiFi')">Wi-Fi</button>
<button class="tablinks" onclick="openTab(event, 'Other')">Прочие</button>
</div>
<div id="WiFi" class="tabcontent">
<form action='/save_wifi' method='POST'>
<div class=form-group>
<label>Режим:</label>
<label><input type='radio' name='mode' value='hotspot' %s1> Точка доступа</label>
<label><input type='radio' name='mode' value='router' %s2> Подключение к роутеру</label>
</div>
<div class=form-group id='wifiCredentials'>
<label>SSID:</label><input type='text' name='ssid' value="%.ssid">
<label>Пароль:</label><input type='text' name='pass' value="%.pass">
</div>
<div class=n>
<button type='submit' class=b>Сохранить настройки Wi-Fi</button>
</div>
</form>
<button class=b onclick="window.location.href='/'">Назад</button>
</div>
<div id="Other" class="tabcontent">
<form action='/save_mode' method='POST'>
<div class=form-group>
<label>Мощность ТЭНа (Вт):</label><input type='number' name='PMAX' value='%.PMAX'>
</div>
<div class=n>
<a href='/boost_load' class='b'>Калибровка ТЭН-а</a>
</div>
<div class=separator></div>
<div class=form-group>
<label>Периодичность регулирования (с):</label><input type='number' name='time_reg' value='%t_reg'>
</div>
<div class=form-group>
<label>Коэффициент воздействия (1-100):</label><input type='number' name='k_upr' value='%.k_upr'>
</div>
<div class=form-group>
<label>Нижний предел задержки, 0-1000 (мкс):</label><input type='number' name='delay_low' value='%dl_l%'>
</div>
<div class=form-group>
<label>Верхний предел задержки, 9000-10000 (мкс):</label><input type='number' name='delay_high' value='%dl_h%'>
</div>
<div class=form-group>
<label>Порт UDP вещания:</label><input type='number' name='UDP' value="%UDP_p%">
</div>
<div class=form-group>
<label><input type="checkbox" name="remember" value="1"> Запомнить в NVS при применении</label>
</div>
<div class=form-group>
<div class=n>
<button type='submit' class=b>Применить режим</button>
</div>
</div>     
</form>
<div class=separator></div>
<form action='/reset_energy' method='POST'>
<button type='submit' class=b>Сброс счетчика энергии</button>
</form>
<div class=separator></div>
<button class=b onclick="restartDevice()">Перезагрузка</button>
<div class=separator></div>
<button class=b onclick="window.location.href='/'">Назад</button>
</div>
</div>
</div>
</body>
</html>
)=====";