#include "Stab_config.h"
#include "web_pages.h"
#include <WiFiUdp.h>
WiFiUDP udp;

void setupUDPBroadcast() {
    udp.begin(UDP_Port);
}

void broadcastStatus() {
  if (WiFi.status() == WL_CONNECTED) { 
    IPAddress localIP = WiFi.localIP();
    IPAddress subnetMask = WiFi.subnetMask();
    IPAddress broadcastIP;
    
    for (int i = 0; i < 4; i++) {
        broadcastIP[i] = localIP[i] | (~subnetMask[i]);
    }
    uint8_t mode = 0;
    if (heatEnabled)      mode |= 0b00000001;
    if (boostMode)        mode |= 0b00000010;
    if (error)            mode |= 0b00000100;
    if (boostLoadActive)  mode |= 0b00001000;
    String message = "StPr|" + 
                    String(power) + "|" + 
                    String(powerSetpoint) + "|" + 
                    String(mode);
    udp.beginPacket(broadcastIP, UDP_Port);
    udp.print(message);
    udp.endPacket();
    #ifdef DEBUG
    //Serial.println("Broadcast:"+message);
    #endif
  }
}

void setupWebServer() {  
  #ifdef ENABLE_WEB_SERVER
      // Главная страница
      server.on("/", HTTP_GET, [](AsyncWebServerRequest *request) {
          request->send_P(200, "text/html", MAIN_PAGE);
      });

  // Обработчик для проверки перезагрузки
  server.on("/check_reboot", HTTP_GET, [](AsyncWebServerRequest *request) {
    static bool rebooted = true; // Флаг перезагрузки
    if (rebooted) {
      request->send(200, "text/plain", "rebooted");
      rebooted = false; // Сбрасываем флаг после первой проверки
    } else {
      request->send(200, "text/plain", "not_rebooted");
    }
  });

  // Обработчик для чекбокса режима регулятора
  server.on("/set_regulator", HTTP_GET, [](AsyncWebServerRequest *request) {
    static int maxPTemp = maxPower;
    if (request->hasParam("regulator")) {
      String regulatorValue = request->getParam("regulator")->value();
      REG = (regulatorValue == "1");
      if (REG) {
        maxPower = maxPTemp;
        Serial.println("Регулятор введен");
      } else {
        maxPTemp = maxPower;
        maxPower = delayHigh;
        Serial.println("Регулятор выведен");
      }
    }
    request->send(200); // Отправляем пустой ответ
  });

      // Получение данных в JSON
      server.on("/get_data", HTTP_GET, [](AsyncWebServerRequest *request) {
          String json = "{";
          json += "\"R\":" + String( REG ? "true" : "false") + ",";
          json += "\"ER\":" + String( error ? "\"Ошибка симистора.\"" : "\"\"") + ",";
          json += "\"V\":" + String( voltage, 1) + ",";
          json += "\"C\":" + String( current, 2) + ",";
          json += "\"P\":" + String( power) + ",";
          json += "\"PSP\":" + String( powerSetpoint) + ",";
          json += "\"MP\":" + String( maxPower) + ",";
          json += "\"DT\":" + String( delayTime) + ",";
          json += "\"MDT\":" + String( delayHigh) + ",";
          json += "\"mDT\":" + String( delayLow) + ",";
          json += "\"E\":" + String( energy, 3) + ",";
          json += "\"BM\":" + String( boostMode ? "true" : "false") + ",";
          json += "\"HE\":" + String( heatEnabled ? "true" : "false") + ",";
          json += "\"IV\":" + String( insufficientVoltage ? "true" : "false");
          json += "}";
          request->send(200, "application/json", json);
      });
      // Страница настроек
      server.on("/setup_wifi", HTTP_GET, [](AsyncWebServerRequest *request) {
          String html = FPSTR(SETTINGS_PAGE);
          
          // Замена плейсхолдеров
    html.replace("%.ssid", savedSSID);
    html.replace("%.pass", savedPass);
    html.replace("%s1", hotspotMode ? "checked" : "");
    html.replace("%s2", !hotspotMode ? "checked" : "");
    html.replace("%UDP_p%", String(UDP_Port)); 
    html.replace("%t_reg", String(timeReg));
    html.replace("%.k_upr", String(K_upr));
    html.replace("%dl_l%", String(delayLow));
    html.replace("%dl_h%", String(delayHigh));
    html.replace("%.PMAX", String(maxPower));
          
          request->send(200, "text/html", html);
  });

  server.on("/save_mode", HTTP_POST, [](AsyncWebServerRequest *request) {  // Обработчик для сохранения режима регулирования
    if (request->hasParam("time_reg", true)) {
      timeReg = request->getParam("time_reg", true)->value().toInt();
    }
    if (request->hasParam("k_upr", true)) {
      K_upr = request->getParam("k_upr", true)->value().toInt();
    }
    if (request->hasParam("delay_low", true)) {
      delayLow = request->getParam("delay_low", true)->value().toInt();
    }  
    if (request->hasParam("delay_high", true)) {
      delayHigh = request->getParam("delay_high", true)->value().toInt();
    } 
    String rememberValue = "0"; // По умолчанию значение "0", если чекбокс не установлен
    if (request->hasParam("remember", true)) {
      rememberValue = request->getParam("remember", true)->value();
    }
    if (request->hasParam("PMAX", true)) {
      maxPower = request->getParam("PMAX", true)->value().toInt();
    }
    if (request->hasParam("UDP", true)) {
      UDP_Port = (uint16_t) request->getParam("UDP", true)->value().toInt() ;
    } 
    TimeStep = round((delayHigh - delayLow) / 31);
        if (rememberValue == "1") { // Проверяем, установлен ли чекбокс "Запомнить"
      // Сохраняем режим в NVS вместо EEPROM
      saveModeToNVS();
      Serial.println("Mode settings saved to NVS");
        }
    request->redirect("/"); // Перенаправляем на главную страницу
  });
  server.on("/restart", HTTP_GET, [](AsyncWebServerRequest *request) {
    request->send(200, "text/plain", "Перезагрузка...");
    ESP.restart(); // Перезагружаем устройство
  });
  // Обработчик для установки мощности
  server.on("/set_power", HTTP_GET, [](AsyncWebServerRequest *request) {
        if (request->hasParam("power")) {
            String powerValue = request->getParam("power")->value();
            setPower((uint16_t)atof(powerValue.c_str()));
            AsyncWebServerResponse *response = request->beginResponse(200, "text/plain", "OK");
            response->addHeader("Connection", "close");
            request->send(response);
        } else {
            request->send(400, "text/plain", "Missing 'power' parameter");
        }
    });
  // Обработчик для установки задержки
  server.on("/set_delay", HTTP_GET, [](AsyncWebServerRequest *request) {
        if (request->hasParam("delay")) {
            String delayValue = request->getParam("delay")->value();
            delayTime = constrain((uint16_t)atof(delayValue.c_str()), delayLow, delayHigh);
            AsyncWebServerResponse *response = request->beginResponse(200, "text/plain", "OK");
            response->addHeader("Connection", "close");
            request->send(response);
        } else {
            request->send(400, "text/plain", "Missing 'delay' parameter");
        }
    });    
  // Обработчик для включения/выключения режима "Разгон"
  server.on("/set_boost", HTTP_GET, [](AsyncWebServerRequest *request) {
        if (request->hasParam("boost")) {
            String boostValue = request->getParam("boost")->value();
            boost(boostValue == "1");
            AsyncWebServerResponse *response = request->beginResponse(200, "text/plain", "OK");
            response->addHeader("Connection", "close");
            request->send(response);
        } else {
            request->send(400, "text/plain", "Missing 'boost' parameter");
        }
    });
  // Обработчик для включения/выключения нагрева
  server.on("/set_heat", HTTP_GET, [](AsyncWebServerRequest *request) {
    if (request->hasParam("heat")) {
      String heatValue = request->getParam("heat")->value();
      heat(heatValue == "1");
      AsyncWebServerResponse *response = request->beginResponse(200, "text/plain", "OK");
      response->addHeader("Connection", "close");
      request->send(response);
    } else {
      request->send(400, "text/plain", "Missing 'heat' parameter");
    }
  });
  // Обработчик для сохранения настроек Wi-Fi
  server.on("/save_wifi", HTTP_POST, [](AsyncWebServerRequest *request) {
    if (request->hasParam("mode", true)) {
      String mode = request->getParam("mode", true)->value();
      if (mode == "hotspot") {
        hotspotSetup();
      } else {
        String savedSSID = request->getParam("ssid", true)->value();
        String savedPass = request->getParam("pass", true)->value();
        WiFiSetup(savedSSID, savedPass);
      }
    }
    // Перенаправляем на главную страницу после сохранения
    request->redirect("/");
  }); 

  // Обработчик для сброса счетчика энергии
  server.on("/reset_energy", HTTP_POST, [](AsyncWebServerRequest *request) {
    PzemEnClear = true; // Сбрасываем счетчик энергии
    request->redirect("/"); // Перенаправляем на главную страницу
  });
  // Обработчик для прогрузки ТЭН
  server.on("/boost_load", HTTP_GET, [](AsyncWebServerRequest *request) {
      StartCalibrateTEN();
      request->redirect("/");
    });
  // Запуск сервера
  server.begin();
  #endif // ENABLE_WEB_SERVER
  #ifdef ENABLE_UDP_BROADCAST
  setupUDPBroadcast();
  #endif
}

