#include "Stab_config.h"
// Добавляем функции для работы с int и float в NVS
void writeNVSInt(const char* nspc, const char* key, int32_t value) {
  preferences.begin(nspc, false);
  preferences.putInt(key, value);
  preferences.end();
}

int32_t readNVSInt(const char* nspc, const char* key, int32_t defaultValue = 0) {
  preferences.begin(nspc, true);
  int32_t result = preferences.getInt(key, defaultValue);
  preferences.end();
  return result;
}

void writeNVSFloat(const char* nspc, const char* key, float value) {
  preferences.begin(nspc, false);
  preferences.putFloat(key, value);
  preferences.end();
}

float readNVSFloat(const char* nspc, const char* key, float defaultValue = 0.0) {
  preferences.begin(nspc, true);
  float result = preferences.getFloat(key, defaultValue);
  preferences.end();
  return result;
}

// Функция для удаления ключа из NVS
void removeNVSKey(const char* nspc, const char* key) {
  preferences.begin(nspc, false);
  preferences.remove(key);
  preferences.end();
}

// Функция для проверки существования ключа в NVS
bool nvsKeyExists(const char* nspc, const char* key) {
  preferences.begin(nspc, true);
  bool exists = preferences.isKey(key);
  preferences.end();
  return exists;
}
// Функции для работы с NVS
void writeNVSString(const char* nspc, const char* key, String data) {
  preferences.begin(nspc, false);
  preferences.putString(key, data);
  preferences.end();
}

String readNVSString(const char* nspc, const char* key, String defaultValue = "") {
  preferences.begin(nspc, true);
  String result = preferences.getString(key, defaultValue);
  preferences.end();
  return result;
}

void writeNVSUint(const char* nspc, const char* key, uint32_t value) {
  preferences.begin(nspc, false);
  preferences.putUInt(key, value);
  preferences.end();
}

uint32_t readNVSUint(const char* nspc, const char* key, uint32_t defaultValue = 0) {
  preferences.begin(nspc, true);
  uint32_t result = preferences.getUInt(key, defaultValue);
  preferences.end();
  return result;
}

void writeNVSBool(const char* nspc, const char* key, bool value) {
  preferences.begin(nspc, false);
  preferences.putBool(key, value);
  preferences.end();
}

bool readNVSBool(const char* nspc, const char* key, bool defaultValue = false) {
  preferences.begin(nspc, true);
  bool result = preferences.getBool(key, defaultValue);
  preferences.end();
  return result;
}


void startHotspot() {// Старт точки доступа
  #ifdef ENABLE_WIFI  
  hotspotMode = true;
  WiFi.softAP("PoverStabiliser", "12345678");
  Serial.println("Точка доступа запущена. IP: " + WiFi.softAPIP().toString());
  #endif // WIFI
}

void ConnectWIFI(String SSID, String Pass){
  #ifdef ENABLE_WIFI  
   WiFi.begin(SSID, Pass);
   Serial.print("Подключение к WiFi "); 
   Serial.println(SSID); //Serial.println(savedPass);
    uint32_t startTime = millis();
    while (WiFi.status() != WL_CONNECTED && millis() - startTime < 10000) {
      Serial.print(".");
      delay(200);
    } 
    Serial.println();
  #endif // WIFI
}

void WiFiSetup(String savedSSID, String savedPass) {
#ifdef ENABLE_WIFI  
  hotspotMode = false;
  writeNVSString(NVS_WIFI_NAMESPACE, "ssid", savedSSID);
  writeNVSString(NVS_WIFI_NAMESPACE, "pass", savedPass);
  
  if (WiFi.status() != WL_CONNECTED) {
    ConnectWIFI(savedSSID, savedPass);
  }
#endif
}

void hotspotSetup() {
#ifdef ENABLE_WIFI  
  Serial.println("Starting hotspot...");
  hotspotMode = true;
  writeNVSString(NVS_WIFI_NAMESPACE, "ssid", "");
  writeNVSString(NVS_WIFI_NAMESPACE, "pass", "");
  startHotspot();
#endif
}

void initWiFi() {
#ifdef ENABLE_WIFI  
  savedSSID = readNVSString(NVS_WIFI_NAMESPACE, "ssid", "");
  savedPass = readNVSString(NVS_WIFI_NAMESPACE, "pass", "");
  
  if (savedSSID.length() != 0) {
    ConnectWIFI(savedSSID, savedPass);
  }
  
  if (WiFi.status() != WL_CONNECTED && defaultSSID != "") {
    savedSSID = defaultSSID;
    savedPass = defaultPass;
    ConnectWIFI(savedSSID, savedPass);
  }
  
  if (WiFi.status() != WL_CONNECTED) {
    Serial.println("Failed to connect to WiFi. Starting hotspot...");
    startHotspot();
  } else {
    Serial.println();
    Serial.print("Connected to WiFi. IP: ");
    Serial.println(WiFi.localIP());
    Serial.print("Signal Strength (RSSI): ");
    Serial.print(WiFi.RSSI()); 
    Serial.println(" dBm");
    localIP = WiFi.localIP().toString();
  }
#endif    
}

void loopWIFI(){
  #ifdef ENABLE_WIFI  
  #ifdef WIFI_RECONNECT
  if (WiFi.status() != WL_CONNECTED) {
    WiFi.begin(savedSSID, savedPass);
    RSSI = 0; 
  } else {
    RSSI = WiFi.RSSI(); 
  }
  #endif
  #endif
}