@echo off
setlocal enabledelayedexpansion

echo ========================================
echo    Samovaritch Libraries Restorer
echo ========================================

set "ARDUINO_PATH=%USERPROFILE%\Documents\Arduino"
set "ARDUINO_LIB=%ARDUINO_PATH%\libraries"

echo Arduino Libraries: %ARDUINO_LIB%
echo.

:: Поиск последней резервной копии
set "LATEST_BACKUP="
set "BACKUP_COUNT=0"

:find_latest
if exist "%ARDUINO_LIB%_old_!BACKUP_COUNT!" (
    set "LATEST_BACKUP=%ARDUINO_LIB%_old_!BACKUP_COUNT!"
    set /a BACKUP_COUNT+=1
    goto find_latest
)

if not defined LATEST_BACKUP (
    echo No backup found! Nothing to restore.
    pause
    exit /b 0
)

:: Удаление текущих библиотек и восстановление из бэкапа
echo Found backup: !LATEST_BACKUP!
echo.

echo.
echo Removing current libraries...
if exist "%ARDUINO_LIB%" rmdir "%ARDUINO_LIB%" /S /Q

echo Restoring original libraries...
ren "!LATEST_BACKUP!" "libraries"

echo Libraries restored successfully!
echo.
pause