// Основные настройки проекта для ESP8266
#define ENABLE_OLED_DISPLAY    // Раскомментируйте для использования дисплея
#define ENABLE_BUTTON          // Раскомментируйте для использования кнопки
#define ENABLE_OTA             // OTA-обновление
#define ENABLE_WIFI            // Работа с WiFi
#define ENABLE_WEB_SERVER      // Веб-сервер
#define ENABLE_UDP_BROADCAST   // UDP рассылка статуса для управления по WIFI
#define ENABLE_USART_SAMOVAR   // Управление по USART
#define PMAX_TEN 2027          // Номинальная мощность ТЭНа по умолчанию
#define DEFAULT_TIME_REG 4     // Период регулирования по умолчанию (1-8 с)
#define DEFAULT_K_UPR 50       // Коэффициент воздействия по умолчанию (1-100)
#define DEFAULT_DELAY_LOW 1000 // Нижний предел задержки (мкс) для фазового регулирования
#define DEFAULT_DELAY_HIGH 9000// Верхний предел задержки (мкс)
#define TIME_CHECK_TRIAK 30000  // Время млсек, через которое будет переход в режим ошибки если мощность выше уставки на Рмакс * K_CHECK
#define K_CHECK 0.2             // доля максимальной мощности ТЭНа, при превышении отклонения от задания на неё сработает защита от пробития симистора
//#define REGDEBUG              // включение отладки
//#define EMULATE               // эмуляция PZEM для отладки Самоварыча


// Настройки по умолчанию для WiFi
#define defaultSSID "" // Ссид и пароль по умолчанию, позволяет использовать два набора, первый можно сохранить в NVS 
#define defaultPass "" // через WEB интерфейс, это второй по ходу загрузки
#define WIFI_RECONNECT // Переподключаться при потере связи

#define UDP_BROADCAST_INTERVAL 1000 // миллисекунд, период отправки UDP пакетов
// Константы для пинов
#define boostPin 16            // Реле разгона
#define heatPin 14             // Реле ТЭНов
#define zeroCrossPin 12        // Детектор нуля
#define triacPin 15            // Симистор 
#define BUTTON_PIN 13          // Кнопка 
#define PZEM_RX_PIN 0          // RX, пины для software serial PZEM-004T
#define PZEM_TX_PIN 2          // TX 
//1 и 3 - TX0/RX0 для связи с Самоваром, 4 и 5 I2C. Свободные пины: A0 (0-1В)


//EEPROM
#define EEPROM_SIZE 512
#define MODE_SAVED_FLAG_VALUE 2     // Значение флага, указывающее, что номер режима регулятора был сохранен

// Адреса EEPROM для Wi-Fi
#define SSID_ADDR 0                 // 32 байта (SSID + нулевой символ)
#define PASS_ADDR 33                // 32 байта (пароль + нулевой символ)

// Адреса EEPROM для режима регулятора

#define MODE_SAVED_FLAG_ADDR 66    // 1 байт (флаг сохранения режима)
#define TIME_REG_ADDR 67           // 1 байта (период регулирования) free
#define K_UPR_ADDR 68              // 1 байта (коэффициент воздействия)
#define DELAY_LOW_ADDR 69          // 4 байта (нижний предел задержки)
#define DELAY_HIGH_ADDR 73         // 4 байта (верхний предел задержки)
#define PMAX_TEN_ADDR 77           // 4 байт (номинальная мощность ТЭНа)
#define PL_ADDR 81                 // 64 байт (Калибровочная таблица)
#define UDP_PORT_ADDR 145           // 2 байт (Порт пещания UDP)

#if defined(ENABLE_UDP_BROADCAST)
#define ENABLE_WEB_SERVER 
#endif
#if defined(ENABLE_WEB_SERVER) || defined(ENABLE_OTA)
#define ENABLE_WIFI 
#endif

#define ON true
#define OFF false
