// web_pages.h
#pragma once
#include <Arduino.h>

// Главная страница
const char MAIN_PAGE[] PROGMEM = R"=====(<!doctype html><html><head><meta charset=utf-8>
<meta name=viewport content="width=device-width,initial-scale=1"><title>Стабилизатор</title>
<style>body{font-family:Arial,sans-serif;background:#121212;color:#eee;margin:0;padding:10px}
.c{max-width:800px;margin:0 auto}h1,h2{text-align:center}.d{background:#1e1e1e;border-radius:10px;padding:15px;margin:10px 0}
.g{display:grid;grid-template-columns:1fr 1fr;gap:10px}.v{font-size:1.2em;color:#4CAF50}.a{color:#ff5555}.n{margin:20px 0}
.b{background:#4CAF50;border:0;padding:8px 15px;border-radius:5px;cursor:pointer;min-width:120px;color:#fff;text-decoration:none}
.b:hover{background:#45a049}.no-data{color:#ff5555}@media (max-width:600px){.c{max-width:100%;padding:0 10px}}
</style><link rel="icon" href="https://www.samovar-tool.ru/doc/device/img/drex_tehn_custom.png" type="image/png">
<script>let lUT = 0;let R_M = true;let lastMDT = 50, lastmDT = 10;
function u_D_S() {const now = Date.now();const elements = document.querySelectorAll('.v');elements.forEach(el => {if (now-lUT>10000) {el.innerText = "???";
el.classList.add('no-data');} else {el.classList.remove('no-data');}});}let PUT;
function uP(value) {let url;if (R_M) {url = '/set_power?power=' + encodeURIComponent(value);} else {url = '/set_delay?delay=' + encodeURIComponent(value);}
document.getElementById('P_I').value = value;document.getElementById('p_R').value = value;clearTimeout(PUT);
PUT = setTimeout(() => {fetch(url, {method: 'GET'}).then(response => {return response.text();});}, 100);}
function tB() {const b_V = document.getElementById('boost').checked ? '1' : '0';fetch('/set_boost?boost=' + b_V, {method: 'GET'});}
function tH() {const h_V = document.getElementById('heat').checked ? '1' : '0';fetch('/set_heat?heat=' + h_V, {method: 'GET'});}
function tR() {const R_V = document.getElementById('RG').checked ? '1' : '0';fetch('/set_regulator?regulator=' + R_V, {method: 'GET'});R_M = document.getElementById('RG').checked;updateUImode();}
function updateUImode() {const pB = document.getElementById('pB');
const P_L = document.getElementById('P_L');const P_I = document.getElementById('P_I');const p_R = document.getElementById('p_R');
const M_PV = document.getElementById('M_PV');const m_PV = document.getElementById('m_PV');
if (R_M) {P_L.innerText = 'Установка мощности (Вт):';P_I.min = 0;P_I.max = document.getElementById('M_P').innerText.replace(' Вт', '');
p_R.min = 0;p_R.max = document.getElementById('M_P').innerText.replace(' Вт', '');p_R.style.transform = 'scaleX(1)';
p_R.style.direction = 'ltr';m_PV.innerText = '0';M_PV.innerText = document.getElementById('M_P').innerText;
} else {P_L.innerText = 'Установка задержки (мкс):';const mDT = parseInt(lastmDT);const MDT = parseInt(lastMDT);P_I.min = mDT;
P_I.max = MDT;p_R.min = mDT;p_R.max = MDT;p_R.style.transform = 'scaleX(-1)';p_R.style.direction = 'rtl';
m_PV.innerText = mDT;M_PV.innerText = MDT;}}function u_D() {fetch('/get_data').then(response => {if (!response.ok) throw new Error('Network error');
return response.json();}).then(data => {lUT = Date.now();const prevR_M = R_M;R_M = document.getElementById('RG').checked;
lastMDT = data.MDT;lastmDT = data.mDT;document.getElementById('RG').checked = data.R;document.getElementById('v').innerText = data.V + " В";
document.getElementById('current').innerText = data.C.toFixed(2) + " A";document.getElementById('power').innerText = data.P + " Вт";
document.getElementById('pSP').innerText = data.PSP + " Вт";document.getElementById('M_P').innerText = data.MP + " Вт";
document.getElementById('delayTime').innerText = data.DT + " (из "+ data.mDT + "-" + data.MDT + ")";document.getElementById('energy').innerText = data.E.toFixed(3) + " кВт·ч";
document.getElementById('boost').checked = data.BM;document.getElementById('heat').checked = data.HE;document.getElementById('I_V').style.display = data.IV ? 'block' : 'none';
document.getElementById('alarm').innerText = data.ER;if (data.ER) {document.getElementById('alarm').style.color = 'red';}if (prevR_M != R_M) {
updateUImode();}if (!R_M) {const P_I = document.getElementById('P_I');const p_R = document.getElementById('p_R');
if (P_I.value != data.DT) {p_R.value = data.DT;}const M_PV = document.getElementById('M_PV');
const m_PV = document.getElementById('m_PV');if (m_PV) {m_PV.innerText = data.mDT;M_PV.innerText = data.MDT;}} else {document.getElementById('M_PV').innerText = data.MP + " Вт";
document.getElementById('p_R').max = data.MP;}});}setInterval(u_D_S, 1000);setInterval(u_D, 2000);u_D();</script>
</head>
<body><div class=c><h1>Стабилизатор мощности</h1><div class=d><label><input type='checkbox' id='RG' onchange='tR()'> Регулятор.</label><label id="alarm"></label>
<p>Напряжение: <span id="v" class=v>---</span>, Ток: <span id="current" class=v>---</span></p><p>Мощность: <span id="power" class=v>---</span>. Целевая: <span id="pSP" class=v>---</span></p>
<p>MAX: <span id="M_P" class=v>---</span></p><p>Задержка открытия симистора: <span id="delayTime" class=v>---</span></p><p>Счетчик: <span id="energy" class=v>---</span></p>
<div id="pB"><span id="P_L">Установка мощности (Вт):</span><input type="number" id="P_I" name="power" min="0" max="10000" onchange="uP(this.value)"><br>
<span id="m_PV">0</span> <input type="range" id="p_R" min="0" max="10000" oninput="uP(this.value)"> <span id="M_PV" class=v>---</span><br><br>
</div><label>Режим разгона: <input type='checkbox' id='boost' onchange='tB()'></label><br><br><label>Включить нагрев: <input type='checkbox' id='heat' onchange='tH()'></label><br><br>
<a href='/setup_wifi' class='b'>Настройки</a> <br><p id="I_V" style="color:red; display:none;">Недостаточное напряжение.</p></div>
</body></html>)=====";

// -----------------------------------------------------------------------------------------------------------------Страница настроек
const char SETTINGS_PAGE[] PROGMEM = R"=====(
<!doctype html>
<html>
<head>
<meta charset=utf-8>
<meta name=viewport content="width=device-width,initial-scale=1">
<title>Настройки</title>
<style>
body{font-family:Arial,sans-serif;background:#121212;color:#eee;margin:0;padding:10px}
.c{max-width:800px;margin:0 auto}
h1,h2{text-align:center;color:#4CAF50}
.d{background:#1e1e1e;border-radius:10px;padding:15px;margin:10px 0}
.g{display:grid;grid-template-columns:1fr 1fr;gap:10px}
.v{font-size:1.2em;color:#4CAF50}.a{color:#ff5555}.n{margin:20px 0}
.b{background:#4CAF50;border:0;padding:8px 15px;border-radius:5px;cursor:pointer;min-width:120px;color:#fff;text-decoration:none}
.b:hover{background:#45a049}
.no-data{color:#ff5555}
label{display:flex;align-items:center;gap:10px;margin-bottom:5px}
input[type="checkbox"], input[type="radio"] {width:auto;margin:0}
input:not([type="checkbox"]):not([type="radio"]), select{width:100%;padding:10px;box-sizing:border-box;background:#333;color:#eee;border:1px solid #444;border-radius:5px;font-size:16px}
.tab{overflow:hidden;border:1px solid #444;background-color:#1e1e1e;border-radius:5px 5px 0 0}
.tab button{background-color:inherit;float:left;border:none;outline:none;cursor:pointer;padding:14px 16px;transition:0.3s;color:#eee}
.tab button:hover{background-color:#333}
.tab button.active{background-color:#4CAF50}
.tabcontent{display:none;padding:15px;border:1px solid #444;border-top:none;background:#1e1e1e;border-radius:0 0 5px 5px}
.separator{border-top:1px solid #444;margin:20px 0}
@media (max-width:600px){.c{padding:0 10px}}
</style>
<script>
function openTab(evt, tabName) {
var i, tabcontent, tablinks;
tabcontent = document.getElementsByClassName("tabcontent");
for (i = 0; i < tabcontent.length; i++) {
tabcontent[i].style.display = "none";
}
tablinks = document.getElementsByClassName("tablinks");
for (i = 0; i < tablinks.length; i++) {
tablinks[i].className = tablinks[i].className.replace(" active", "");
}
document.getElementById(tabName).style.display = "block";
evt.currentTarget.className += " active";
}
function restartDevice() {
if (confirm("Вы уверены, что хотите перезагрузить устройство?")) {
fetch('/restart', { method: 'GET' });
}
}
window.onload = function() {
document.getElementById('Other').style.display = "block";
};
</script>
</head>
<body>
<div class=c>
<h1>Настройки</h1>
<div class=d>
<div class=tab>
<button class="tablinks" onclick="openTab(event, 'WiFi')">Wi-Fi</button>
<button class="tablinks" onclick="openTab(event, 'Other')">Прочие</button>
</div>
<div id="WiFi" class="tabcontent">
<form action='/save_wifi' method='POST'>
<div class=form-group>
<label>Режим:</label>
<label><input type='radio' name='mode' value='hotspot' %s1> Точка доступа</label>
<label><input type='radio' name='mode' value='router' %s2> Подключение к роутеру</label>
</div>
<div class=form-group id='wifiCredentials'>
<label>SSID:</label><input type='text' name='ssid' value="%.ssid">
<label>Пароль:</label><input type='text' name='pass' value="%.pass">
</div>
<div class=n>
<button type='submit' class=b>Сохранить настройки Wi-Fi</button>
</div>
</form>
<button class=b onclick="window.location.href='/'">Назад</button>
</div>
<div id="Other" class="tabcontent">
<form action='/save_mode' method='POST'>
<div class=form-group>
<label>Мощность ТЭНа (Вт):</label><input type='number' name='PMAX' value='%.PMAX'>
</div>
<div class=n>
<a href='/boost_load' class='b'>Калибровка ТЭН-а</a>
</div>
<div class=separator></div>
<div class=form-group>
<label>Периодичность регулирования (с):</label><input type='number' name='time_reg' value='%t_reg'>
</div>
<div class=form-group>
<label>Коэффициент воздействия (1-100):</label><input type='number' name='k_upr' value='%.k_upr'>
</div>
<div class=form-group>
<label>Нижний предел задержки, 0-1000 (мкс):</label><input type='number' name='delay_low' value='%dl_l%'>
</div>
<div class=form-group>
<label>Верхний предел задержки, 9000-10000 (мкс):</label><input type='number' name='delay_high' value='%dl_h%'>
</div>
<div class=form-group>
<label>Порт UDP вещания:</label><input type='number' name='UDP' value="%UDP_p%">
</div>
<div class=form-group>
<label><input type="checkbox" name="remember" value="1"> Запомнить в NVS при применении</label>
</div>
<div class=form-group>
<div class=n>
<button type='submit' class=b>Применить режим</button>
</div>
</div>     
</form>
<div class=separator></div>
<form action='/reset_energy' method='POST'>
<button type='submit' class=b>Сброс счетчика энергии</button>
</form>
<div class=separator></div>
<button class=b onclick="restartDevice()">Перезагрузка</button>
<div class=separator></div>
<button class=b onclick="window.location.href='/'">Назад</button>
</div>
</div>
</div>
</body>
</html>
)=====";